/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */


#ifndef SFWNPQTPLUGIN_H
#define SFWNPQTPLUGIN_H

#include <QObject>
#include <QEvent>
#include <QRegion>
#ifdef __SYMBIAN32__
#ifdef __WINSCW__
    #undef _WIN32
#endif //__WINSCW__

#ifdef CWRT_BUILDING_NINETWO
// there is bug is ninetwo qmake, which always finds headers from
// /epoc32/include/mw
#include "../../3rdparty/npapi/npapi.h"
#else
#include <npapi.h>
#endif

#ifdef __WINSCW__
    #define _WIN32
#endif //__WINSCW__
#endif // __SYMBIAN32__
#include <npinterface.h>

class ServiceFrameworkNPQtPlugin : public QObject, NPInterface
{
    Q_OBJECT
    Q_INTERFACES(NPInterface)

    public:
        NPError NP_Initialize(NPNetscapeFuncs *aNPNFuncs, NPPluginFuncs *aNPPFuncs);
        void NP_Shutdown();
        char* NP_GetMIMEDescription();
};

#endif
