/*
* ==============================================================================
*  Name        : sfwnpqtplugin.cpp
*  Part of     : Service Framework / NP Plugin
*  Description : Plug-in to CWRT Browser
*  Version     : %version: 1 % << Don't touch! Updated by Synergy at check-out.
*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#include <QtPlugin>
#include "sfwnpqtplugin.h"
#include "np_entry.h"

#define MIME_DESC "application/x-sfw-plugin;s60;SFW plugin"

/*
 * NP Interface Implementation
 */
NPError ServiceFrameworkNPQtPlugin::NP_Initialize(NPNetscapeFuncs *aNPNFuncs, NPPluginFuncs *aNPPFuncs) {

    // use functions in np_entry
    NPError err = ::NP_Initialize(aNPNFuncs);
    if ( err != NPERR_NO_ERROR ) {
        return err;
    }

    return ::NP_GetEntryPoints(aNPPFuncs);
}

/*
 * NP Interface Implementation
 */
void ServiceFrameworkNPQtPlugin::NP_Shutdown()
{
    // use functions in np_entry
    ::NP_Shutdown();
}

/*
 * NP Interface Implementation
 */
char* ServiceFrameworkNPQtPlugin::NP_GetMIMEDescription()
{
    return MIME_DESC;
}


Q_EXPORT_PLUGIN2(npsfwqtplugin, ServiceFrameworkNPQtPlugin);
