#
# ============================================================================
#  Name        : npsfwplugin.pro
#  Part of     : WRT / Service Framework
#  Description : Project definition file for project browser plugin
#  Version     : %version: 35 % << Don't touch! Updated by Synergy at check-out.
#
# Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
#
# This file is part of Qt Web Runtime.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public License
# version 2.1 as published by the Free Software Foundation.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

TARGET       = npsfwplugin
TEMPLATE     = lib
CONFIG      += dll
unix:!symbian {
    CONFIG  += plugin
}

include($$PWD/../qtsfw.pri)

ROOT_DIR = $$PWD/../../..
WRT_DIR = $$ROOT_DIR/wrt
!symbian:include($$WRT_DIR/cwrt-webkit.pri)

include($$PWD/npsfwplugin.pri)

!maemo5 {
LIBS += -lwrtnpjsbinding
}

symbian {
    TARGET.UID3 = 0x102829C7
    TARGET.UID2 = 0x10009D8D
    TARGET.VID = 0x101FB657
    INCLUDEPATH += $$MW_LAYER_SYSTEMINCLUDE
    TARGET.CAPABILITY = ALL -TCB
    INCLUDEPATH += $$(EPOCROOT)Epoc32/include/ecom/ 
    TARGET.EPOCALLOWDLLDATA = 1
    debug {
        LIBS += -lflogger
    }
    DEPENDPATH  += $$PWD/platform/s60
    HEADERS += $$PWD/platform/s60/sfwsymbiannpplugin.h 
    SOURCES += $$PWD/platform/s60/sfwsymbiannpplugin.cpp
    LIBS += -lecom
    
    MMP_RULES -= EXPORTUNFROZEN
    
    MMP_RULES +=  "$${LITERAL_HASH}if defined(WINSCW)" \
                  "DEFFILE .\platform\s60\npsfwplugin_winscw.def"\  
                  "$${LITERAL_HASH}else" \
                  "DEFFILE .\platform\s60\npsfwplugin_armv5.def"\    
                  "$${LITERAL_HASH}endif"  
    
    MMP_RULES +=  "START RESOURCE 102829C7.rss" \
                  "TARGETPATH resource\plugins" \
                  "TARGET npsfwplugin.rsc" \
                  "END"
                  
# Check arguments for configurations, default S60 5.0, check in decending order as 3.2 includes 3.1                 
    exists($$(EPOCROOT)Epoc32/data/Z/system/install/Series60v5.0.sis) {
        BLD_INF_RULES.prj_mmpfiles += "./platform/s60/dummywrtjscoreext/dummy.mmp"
        LIBS += -lnpscript
    }
    else:exists($$(EPOCROOT)Epoc32/data/Z/system/install/Series60v3.2.sis) {
        S60Version += 3_2 
    }
    else:exists($$(EPOCROOT)Epoc32/data/Z/system/install/Series60v3.1.sis) {
        S60Version += 3_1 
    }
    else {
        LIBS += -lnpscript
    }
    contains(S60Version, 3_2)|contains(S60Version, 3_1) {
        INCLUDEPATH += $$(EPOCROOT)Epoc32/include/libc/
        LIBS += -ljavascriptcore
   
        !exists($$(EPOCROOT)Epoc32/include/oem/Browser_platform_variant.hrh) {
            BLD_INF_RULES.prj_mmpfiles += "./platform/s60/wrtjscoreext/group/wrtjscoreext.mmp"
            LIBS += -lwrtjscoreext
        }
        else {
            myMmpBlock = \
                "$${LITERAL_HASH}include <oem/Browser_platform_variant.hrh>" \
                "$${LITERAL_HASH}if BRDO_APP_VERSION_MAJOR < 7" \ 
                "./platform/s60/wrtjscoreext/group/wrtjscoreext.mmp" \
                "$${LITERAL_HASH}else" \
                "./platform/s60/dummywrtjscoreext/dummy.mmp" \
                "$${LITERAL_HASH}endif"
            BLD_INF_RULES.prj_mmpfiles += myMmpBlock
            myLibBlock = \
                "$${LITERAL_HASH}if BRDO_APP_VERSION_MAJOR < 7" \
                "-lwrtjscoreext" \
                "$${LITERAL_HASH}endif"
            LIBS += myLibBlock
        }
    }
    
    contains(QT_SFW, QTServiceFramework) {
        npsfwplugin.sources = wrtnpjsbinding.dll \ 
                              npsfwplugin.dll
    
        npsfwplugin.path = /sys/bin
        
        npsfwpluginresources.sources = /epoc32/data/Z/Resource/Plugins/npsfwplugin.rsc
        npsfwpluginresources.path = /resource/plugins
    
        DEPLOYMENT += npsfwplugin npsfwpluginresources        
    }
}

win32 {
    DEFINES += _WINDOWS XP_WIN
    INCLUDEPATH += $$PWD/platform/win 
    HEADERS += $$PWD/platform/win/stdint.h
    LIBS += -luser32
    DEF_FILE += $$PWD/platform/win/npsfwplugin.def
    RC_FILE = $$PWD/platform/win/npsfwplugin.rc
    SFW_PLUGIN_FILE = $$DESTDIR/$$TARGET".dll"
    SFW_PLUGIN_FILE = $$replace(SFW_PLUGIN_FILE, "\/", "\\")
    SFW_PLUGIN_DEST = "C:\\Program Files\\Mozilla Firefox\\plugins\\"
    exists($$SFW_PLUGIN_DEST){
        QMAKE_POST_LINK += $(COPY) $$SFW_PLUGIN_FILE  \"$$SFW_PLUGIN_DEST\"
    }
    SOURCES += $$PWD/platform/win/dllmain.cpp
} 
win32-msvc* {
    DEFINES += _X86_ MSVC
    QMAKE_LFLAGS += /MACHINE:x86
}

INCLUDEPATH += $$CWRT_INCLUDE

unix:!symbian {
    target.path = $$CWRT_INSTALL_NPPLUGIN_DIR
} 

maemo5 {
    TARGET = WrtNpSFWPlugin

    LIBS += -lWrtNpJsBinding
}
