/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */


#ifndef signalforwarder_h
#define signalforwarder_h

#include "npdef.h"

#include <QObject>
#include <QList>

namespace WRT {

    //Forward declaration
    class BindingUtility;

    // Helper class for forwarding signal emissions to the respective JavaScript
    class SignalForwarder : public QObject
    {
    public:
        enum CallbackState
        {
            DisConnected = 0, // disconnected
            Connected, // connected
            InProgress, // callback in progress
            Completed // callback completed
        };
    public:
        SignalForwarder(NPP& npp,
                        NPObject* npObject,
                        NPObject* callback,
                        QList<QByteArray>& parameterList,
                        BindingUtility& bindingUtility,
                        int connectionId=-1);
        ~SignalForwarder();

        int qt_metacall(QMetaObject::Call callType, int index, void **args);
        int id();
        SignalForwarder::CallbackState callbackState();
        void setCallbackState(SignalForwarder::CallbackState state);
    private:
        NPP&      m_npp;     // execution context of JS
        NPObject* m_cbObject; // JS callback object passed in ObjectBinding::Connect.
                              // Save here for call back
        NPObject* m_function; // JS callback function
        QList<QByteArray> m_argNames; // names of arguments
        NPIdentifier m_npidCall; // JS script "call" API
        BindingUtility& m_bindingUtility;
        int  m_id; // callback ID
        CallbackState m_state; // flag indicates if a callback is on going
    };

} // namespace

#endif // signalforwarder_h
