/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */


#ifndef scriptableobjectbase_h
#define scriptableobjectbase_h

#include "npdef.h"

#ifdef __SYMBIAN32__
// From npruntime.h
#define NP_CLASS_STRUCT_VERSION_CTOR 3
#endif  //__SYMBIAN32__


namespace WRT {

#ifndef __SYMBIAN32__
    #define DECLARE_NPOBJECT_CLASS_WITH_BASE_END \
        NPScriptableObjectBase::_Enumerate,      \
        NPScriptableObjectBase::_Construct       \
        }
#else
#if defined(__S60_50__)
#define DECLARE_NPOBJECT_CLASS_WITH_BASE_END \
    NPScriptableObjectBase::_Enumerate,      \
    }
#else
    #define DECLARE_NPOBJECT_CLASS_WITH_BASE_END }
#endif // __S60_50__
#endif

    // Allocate a NPObject
    #define DELCARE_ALLOCATE_NPOBJECT(_class) \
    static NPObject* Allocate##_class##NPObject(NPP npp, NPClass* /*aClass*/) \
    { \
        return new _class(npp); \
    }

    //Construct not supported on Symbian
    #define DECLARE_NPOBJECT_CLASS_WITH_BASE(_class)              \
    DELCARE_ALLOCATE_NPOBJECT(_class)                             \
    static NPClass s##_class##_NPClass ATTRIBUTE_USED = {         \
      NP_CLASS_STRUCT_VERSION_CTOR,                               \
      Allocate##_class##NPObject,                                 \
      NPScriptableObjectBase::_Deallocate,                        \
      NPScriptableObjectBase::_Invalidate,                        \
      NPScriptableObjectBase::_HasMethod,                         \
      NPScriptableObjectBase::_Invoke,                            \
      NPScriptableObjectBase::_InvokeDefault,                     \
      NPScriptableObjectBase::_HasProperty,                       \
      NPScriptableObjectBase::_GetProperty,                       \
      NPScriptableObjectBase::_SetProperty,                       \
      NPScriptableObjectBase::_RemoveProperty,                    \
      DECLARE_NPOBJECT_CLASS_WITH_BASE_END

    #define GET_NPOBJECT_CLASS(_class) &s##_class##_NPClass

    // Helper class that can be used to map calls to the NPObject hooks
    // into virtual methods on instances of classes that derive from this class.
    class NPScriptableObjectBase : public NPObject
    {
    public:
        NPScriptableObjectBase(NPP npp);
        virtual ~NPScriptableObjectBase();
        // Virtual NPObject hooks called through this base class. Override as necessary
        virtual void Invalidate();
        virtual bool HasMethod(NPIdentifier methodId);
        virtual bool Invoke(NPIdentifier methodId, const NPVariant *args,
                            uint32_t argCount, NPVariant *result);
        virtual bool InvokeDefault(const NPVariant *args, uint32_t argCount,
                                   NPVariant *result);
        virtual bool HasProperty(NPIdentifier propertyId);
        virtual bool GetProperty(NPIdentifier propertyId, NPVariant *result);
        virtual bool SetProperty(NPIdentifier propertyId, const NPVariant *value);
        virtual bool RemoveProperty(NPIdentifier propertyId);
        virtual bool Enumerate(NPIdentifier **identifier, uint32_t *count);
        virtual bool Construct(const NPVariant *args, uint32_t argCount, NPVariant *result);

        // Static functions for mapping
        static void _Deallocate(NPObject *npobj);
        static void _Invalidate(NPObject *npobj);
        static bool _HasMethod(NPObject *npobj, NPIdentifier methodId);
        static bool _Invoke(NPObject *npobj, NPIdentifier methodId, const NPVariant *args,
                            uint32_t argCount, NPVariant *result);
        static bool _InvokeDefault(NPObject *npobj, const NPVariant *args, uint32_t argCount,
                                   NPVariant *result);
        static bool _HasProperty(NPObject * npobj, NPIdentifier propertyId);
        static bool _GetProperty(NPObject *npobj, NPIdentifier propertyId, NPVariant *result);
        static bool _SetProperty(NPObject *npobj, NPIdentifier propertyId, const NPVariant *value);
        static bool _RemoveProperty(NPObject *npobj, NPIdentifier propertyId);
        static bool _Enumerate(NPObject *npobj, NPIdentifier **identifier, uint32_t *count);
        static bool _Construct(NPObject *npobj, const NPVariant *args, uint32_t argCount,
                               NPVariant *result);
    protected:
        NPP m_Npp;
    };
} // namespace
#endif //scriptableobjectbase_h
