# Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
#
# This file is part of Qt Web Runtime.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public License
# version 2.1 as published by the Free Software Foundation.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
#

#
# jsbinding.pri
#

include($$PWD/../../qtsfw.pri)

INCLUDEPATH += $$PWD/../../inc \
               $$PWD/../ \
               $$PWD/../../../runtimecore \
               $$PWD/../../../settings/inc \
               $$PWD/../../../widgetmanager/src

DEFINES += QT_MAKE_JSBINDING_DLL

HEADERS      = $$PWD/scriptableobjectbase.h \
               $$PWD/signalforwarder.h \
               $$PWD/objectbinding.h \
               $$PWD/serviceobjectbinding.h \
               $$PWD/servicefactory.h \
               $$PWD/bindingutility.h \
               $$PWD/bindingdef.h \
               $$PWD/../npdef.h

SOURCES      = $$PWD/scriptableobjectbase.cpp \
               $$PWD/signalforwarder.cpp \
               $$PWD/servicefactory.cpp \
               $$PWD/objectbinding.cpp \
               $$PWD/serviceobjectbinding.cpp \
               $$PWD/bindingutility.cpp \
               $$PWD/../npn_gate.cpp

!maemo5 {
LIBS += -lsecmgr -lwrtsecurestorage -lWrtSettings -lWidgetUtils

!contains(QT_SFW, QTServiceFramework) {
    LIBS += -lwrtservicehandler
}
}

maemo5 {
    LIBS += -lWrtSecurityManager -lWrtSecureStorage -lWrtSettings -lWrtWidgetUtils

    !contains(QT_SFW, QTServiceFramework) {
        LIBS += -lWrtServiceHandler
    }
}
