/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef __WRT_SQL_POLICY_SERIALIZER_H
#define __WRT_SQL_POLICY_SERIALIZER_H

#include "policyserializer.h"
#include "usercondition.h"
#include "userconditionserializer.h"

class QXmlStreamWriter;

namespace WRT {

  class XMLPolicySerializer : public PolicySerializer, public UserConditionSerializer
  {
  public:
    XMLPolicySerializer();
    ~XMLPolicySerializer();
    bool persist(const QString &key,
                 const QString &store,
                 const QString &domain,
                 const CapabilitySet *capabilities,
                 const AliasSet *aliases);

    bool persist(QByteArray &blob,
                 const QString &domain,
                 const CapabilitySet *capabilities,
                 const AliasSet *aliases);

    bool persist(const CapabilityList &,
                 const unsigned int,
                 const unsigned int);

  private:
    QXmlStreamWriter *m_xmlWriter;
  };

}

#endif  // __WRT_SQL_POLICY_SERIALIZER_H
