/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */



#ifndef __WRT_USERCONDITIONSERIALIZER_H
#define __WRT_USERCONDITIONSERIALIZER_H

#include "condition.h"
#include "capability.h"

namespace WRT {

    /**
    * \class UserConditionSerializer
    * Interface class for serializing conditions.  The implementer
    * can store the current state of capabilities and conditions and
    * the current grant state
    */
    class UserConditionSerializer {
    public:
        /**
        * Persists the state of capabilities and conditions
        * \param[in] aCapabilities - List of capabilities
        * \param[in] aConditions - The conditions for these capabilities
        * \param[in,out] aGrant - Current grant state
        * \return TRUE if successful, else FALSE
        */
        virtual bool persist(const CapabilityList &capabilities,
                             const unsigned int conditions,
                             const unsigned int grant) = 0;
    };

}
#endif  //__WRT_USERCONDITIONSERIALIZER_H
