/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef __WRT_SECPOLICY_H
#define __WRT_SECPOLICY_H

//  INCLUDES
#include <QString>
#include <QByteArray>
#include "capability.h"

// FUNCTION PROTOTYPES


namespace WRT {

    // FORWARD DECLARATION
    class PolicyParser;
    class UserConditionHandler;
    class PolicySerializer;

    // CLASS DECLARATION
    class SecPolicy
    {

    public:
        SecPolicy(const QString &policy);
        SecPolicy(const QByteArray &policy);
        ~SecPolicy();
        const CapabilitySet *evaluateOn(const QString &domain) const;
        const CapabilitySet *evaluate() const;
        bool hasAlias(const QString &capability) const;
        CapabilityList aliasesFor(const QString &capability) const;
        bool persist(const QString &key, const QString &store, const QString &domain) const;
        bool persist(QByteArray &blob, const QString &domain) const;
        void setUserHandler(const UserConditionHandler *handler) const;
        QStringList domains() const;
        QString  defaultDomain() const;

    private:
        PolicyParser *m_parser;
        PolicySerializer *m_serializer;
    };
}
#endif  // __WRT_SECPOLICY_H
