/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */



#ifndef __WRT_CONDITION_H
#define __WRT_CONDITION_H

#include <QObject>

namespace WRT {
    /*!
     * Interface for a condition
     * Condition is an abstract base class for conditions. Inherits from QObject
     * so that conditions may be referred to via qt guarded pointers (QPointer)
     * since conditions may be shared by multiple capabilities
     */
    class Condition : public QObject
    {
        Q_OBJECT
    public:
        /*!
        * Checks whether the condition is met or not
        * \return TRUE if the condition is met, else FALSE
        */
        virtual bool isMet(const QString &serviceName) = 0;

        /*!
        * Resets the state of the condition
        * \return void
        */
        virtual void reset() = 0;

        /*!
        * Saves the condition in a persistant state
        * \return TRUE if the save is successful, else FALSE
        */
        virtual bool persist() = 0;
    };
}

#endif  // __WRT_CONDITION_H
