/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */



#ifndef __WRT_CAPABILITY_H
#define __WRT_CAPABILITY_H

//  INCLUDES

#include <QHash>
#include <QStringList>
#include <QPointer>
#include "condition.h"

// FUNCTION PROTOTYPES

// FORWARD DECLARATION

// CLASS DECLARATION
namespace WRT {
    /*!
    * \typedef CapabilitySet
    * Condition refs hashed by capability name
    */
    typedef QHash<QString, QPointer<Condition> > CapabilitySet;

    /*!
    * \typedef CapabilityList
    * A list of capability names
    */
    typedef QStringList CapabilityList;

    /*!
    * \typedef AliasSet
    * Lists of capabilities hashed by alias name
    */
    typedef QHash<QString, CapabilityList> AliasSet;
}

#endif  // __WRT_CAPABILITY_H
