/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */



#include <QUrl>
#include "apppathhandler.h"
#include "trustparser.h"
//TBD: replace this with WebKit same-origin check

namespace WRT
{

/*!
 * \class AppPathHandler
 * This class uses the origin to find corresponding domain
 * Gets domain for the the policy url that is either equal to the
 * input value or the longest parent url for the input value
 */

/*!
 * Constructor
 * \pre Must have already parsed the policy file.
 */
AppPathHandler::AppPathHandler()
{
    m_parser = NULL;
}

/*!
 * Destructor
 */
AppPathHandler::~AppPathHandler()
{
}

/*!
 * Gets the domain for a specified value
 * \param[in] value - Value to get the domain for
 * \return The requested domain
 */
QString AppPathHandler::domainFor(const QString &value)
{
    QString result;
    if (m_parser) {
        int i = bestMatchFor(value);
        if (i < 0) {
            result = m_parser->defaultAppPathDomain();
        } else {
            result = m_parser->domainFor(ETrustCriteriaAppPath,
                                        (m_parser->values(ETrustCriteriaAppPath))[i]);
        }
    }
    return result;
}

} // end namespace WRT
