/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */


#ifndef __WRT_SECURESTORAGESERVERSESSION_H
#define __WRT_SECURESTORAGESERVERSESSION_H

#include <QObject>
#include <QByteArray>
#include <QHash>
#include <QStringList>
#include <QFile>
#include <QTimer>
#include "storage.h"

namespace WRT {
    // FORWARD DECLARATIONS
    class ClientInfo;
    class SecureStorageMetadata;
    class SecureStorageServerEntry;

    /*!
    * This is the interface to system specific secure storage
    */
    class SecureStorageServerSession : public QObject
    {
        Q_OBJECT
    public:
        SecureStorageServerSession(QObject *aParent = NULL);
        virtual ~SecureStorageServerSession();
        virtual void setName(const QString &aName);
        virtual QString name() const;
        virtual void setMode(Storage::visibility aVisibility,
                             Storage::protection aProtection);
        virtual void setClientInfo(ClientInfo *aClientInfo);
        virtual void init();
        virtual void uninit();
        virtual QByteArray getFileList();
        virtual void saveFileList(const QByteArray &aFileList);
        virtual void saveMetadata(const QByteArray &aMetadata);
        virtual void removeMetadata(const QString &aFileName);
        virtual QByteArray getMetadata(const QString &aFileName);
        virtual void saveKey(const QString &aFileName, const QByteArray &aKey);
        virtual QByteArray getKey(const QString &aFileName);
        virtual QByteArray getFile(const QString &aFileName);

    protected:  // methods
        virtual QString getStorageDir();
        virtual bool verifyFileList();
        virtual void readFileList();
        virtual void writeFileList();
        virtual void internalizeFileList(QIODevice &aDevice);
        virtual void externalizeFileList(QIODevice &aDevice);
        virtual void startFlushTimer();

    private Q_SLOTS:    // slots
        void flushTimeout();

    protected:  // members
        QString m_name;
        Storage::visibility m_visibility;
        Storage::protection m_protection;
        ClientInfo *m_clientInfo;
        QString m_storagePath;
        QHash<QString, QString> m_fileList;
        QHash<QString, SecureStorageServerEntry*> m_entryList;
        QFile m_listFileHandle;
        bool m_fileListInitialized;
        QTimer m_flushTimer;
    };
}

#endif  // __WRT_SECURESTORAGESERVERSESSION_H
