/**
* @class
*/
nokia.device.Messaging = function PSMessagingInterface(){         
        var notifyTid = null;
        var TIME_OUT = 100;
        var integerLimit = 2147483648;
        
        var DeviceException = nokia.device.DeviceException;
        var error = new DeviceException(0,'dummy');
    
        function filterUndefined( obj ){
            if(typeof obj === "object"){
                for(var key in obj) {
                    if(typeof obj[key] === "undefined"){
                        delete obj[key];
                    } 
                    if(typeof obj[key] === "object"){
                        filterUndefined(obj[key]);
                    }
                } 
            }
            return obj;
        }
        
        function removeDuplicateEntry(arr){ 
            if (arr) {
                for (index = 0; index < arr.length; index++) {
                    var element = arr[index];
                    for (dupIndex = index + 1; dupIndex < arr.length; dupIndex++) {
                        if (arr[dupIndex] == element || element == "") {
                            arr.splice(dupIndex, 1);
                        }
                    }
                }
            } 
            return arr;
        }
        
        function asyncErrorFound(op,errorCbk){
            var errMsg;
            if (op.ErrorMessage) {
                errMsg = op.ErrorMessage;
            }
            else {
                errMsg = "Messaging:Operation Failed";
            }
            switch (op.ErrorCode) {
                case error.MISSING_ARG_ERR:
                case error.INVALID_ARG_ERR:
                case error.NOT_SUPPORTED_ERR:
                    throw new DeviceException(op.ErrorCode, errMsg);
                    break;
                default:
                    setTimeout(function(){
                        errorCbk(new DeviceException(op.ErrorCode, errMsg));
                    }, TIME_OUT);
                    break;
            }
        }    
    
        /*
        * Internal
        * qt messaging interface object.
        */

        var qtMessagingIf = nokia._services.load("nokia.device.messaging", "com.nokia.IMessaging", "1.0");          
        
        //getlist eventListener            
        qtMessagingIf.addEventListener("asyncCallback(int,int,QObject*)", getListMessaging_cb);
        
        //send eventListener            
        qtMessagingIf.addEventListener("asyncCallback(int,int,QString)", send_cb);
        
        //notification eventListener
        qtMessagingIf.addEventListener("asyncCallback(int,int,int)", setNotifier_cb);

        /*
         * Messaging getList callback handler
         */
        function getListMessaging_cb(error, transId, iterator){
            var retObj = asyncCallbackMap.get(transId);
            asyncCallbackMap.remove(transId);
            
            if (!retObj) {
                return;
            }
            var sCB = retObj.success_cb;
            var eCB = retObj.error_cb;
            
            if (error == 0) {
                var localIter = new tempIterator(iterator);
                function tempIterator(tIter){
                    this.iter = tIter;
                    this.next = function(){
                        var item = this.iter.next();
                        if (item) 
                            return item;
                        else 
                            return null;
                    };//next
                    this.hasNext = function(){
                        return this.iter.hasNext();
                    };//hasNext
                    this.reset = function(){
                        return this.iter.reset();
                    };//reset
                    this.close = function(){
                        return this.iter.close();
                    }; //close         
                }//tempIterator
                sCB(localIter);
            }
            else {
                if (eCB) {
                    eCB(new DeviceException(error, "Messaging:getList:Operation Failed"));
                }
            }
        }
    
        /*
         * Messaging send callback handler
         */  
        function send_cb(error, transId, recipient){ 
            var retObj = asyncCallbackMap.get(transId);
            
            if (!retObj) {
                return;
            }
            var sCB = retObj.success_cb;
            var eCB = retObj.error_cb;
            var data = retObj.options;
            
            if (data.type == "SMS") {
                data.currentCount++;            
                if(data.currentCount == data.actualCount) {
                   asyncCallbackMap.remove(transId);
                } 
            } 
            else {
                if (data.type == "MMS") {
                    asyncCallbackMap.remove(transId);
                }
            }
            if (error) {
                eCB(new DeviceException(error, "Messaging:send:Operation Failed"), recipient);
                return;
            }
            sCB(recipient);
        }   
        
        /*
         * New Message Notification callback
         */ 
         function setNotifier_cb(error, transId, id){
             var retObj = asyncCallbackMap.get(notifyTid);
             
             if (!retObj) {
                 return;
             }
            var sCB = retObj.success_cb;
            var eCB = retObj.error_cb;
                     
             if (transId == 0) {//this will be always 0 for notification cbk
                 if (error) {
                     eCB(new DeviceException(error, 'Messaging:setNotifier:Operation Failed'));
                     return;
                 }
                 sCB(id);
             }
         }
    
        return {
            /**
            * @constant {String} 
            * interfaceName.
            */      
            interfaceName: "messaging",
            /**
            * @constant {Number} 
            * version.
            */      
            version: nokia.device._interfaces['messaging'],     
            
          /**
          * @constant {Number} sorts by date
          */
          SORT_BY_DATE  : 0,
            
          /**
          * @constant {Number} sorts by sender
          */
          SORT_BY_SENDER  : 1,
    
          /**
          * @constant {Number} to get read messages
          */
          STATUS_READ : 0,
            
          /**
          * @constant {Number} to get unread messages
          */
          STATUS_UNREAD : 1,
      
          /**
          * @constant {Number} to indicate sort in ascending order
          */
          SORT_ASCENDING  : 0,
      
          /**
          * @constant {Number} to indicate sort in descending order
          */
            SORT_DESCENDING  : 1,
          
            /**
             * @constant {String} to indicate the folder type inbox
             */
            INBOX_FOLDER : "INBOX",
            
            /**
             * @constant {String} to indicate the folder type drafts
             */
            DRAFTS_FOLDER : "DRAFTS",
          
            /**
             * @constant {String} to indicate the folder type sentitems
             */
            SENT_FOLDER : "SENTBOX",
          
            /**
             * @constant {String} to indicate the folder type outbox
             */
            OUTBOX_FOLDER : "OUTBOX",
            
            /**
             * @constant {Number} to indicate the message priority high
             */
            PRIORITY_HIGH : 0,
            
            /**
             * @constant {Number} to indicate the message priority medium 
             */
            PRIORITY_NORMAL : 1,
            
            /**
             * @constant {Number} to indicate the message priority low 
             */
            PRIORITY_LOW : 2,
      
            /**
            * Start the device native message editor with pre-populated message data.
            * This is a synchronous method. This method just launches the editor and
            * returns. Its upto the user to operate on the editor.
            * @param {MessageData}
            *            messagedata that conforms to the specified message data schema ({@link MessageData}).
            * @return {void}
            * @exception {DeviceException} Code 1 (MISSING_ARG_ERR): messageData undefined.<br>
            *                Code 2 (INVALID_ARG_ERR): messageData - does not conform to the specified message data schema {@link MessageData}.<br>
            *                Code 101 (DATA_NOT_FOUND_ERR): Attachment file not present in specified path for MMS message.<br>
            *                Code 103 (SERVICE_BUSY_ERR): Message storage unavailable/busy.<br>
            *                Code 109 (URI_NOT_FOUND_ERR): File path specified does not exist.<br>
            *                Code 105 (DATA_OUT_OF_RANGE_ERR):  If any of the input parameter values are out of range.<br>
            */
            startEditor : function(messageData){
                if (!messageData) {
                    //Dummy messageData parameter created
                    var messageData = {
                        type : "SMS"
                    };
                }
                else {
                    if ((typeof messageData) != "object") {
                        throw new DeviceException(error.INVALID_ARG_ERR, 'messageData should be an object');
                    }
                }
     
                var messageDataRight = filterUndefined(messageData);
                var returnValue = qtMessagingIf.startEditor(messageDataRight);
                if(returnValue.ErrorCode != 0){
                    if (returnValue.ErrorMessage) {
                        errMsg = returnValue.ErrorMessage;
                    }
                    else {
                        errMsg = "Messaging:cancel:Operation Failed";
                    }
                    throw new DeviceException(returnValue.ErrorCode, errMsg);
                }
                return 0;
            },
    
            /**
            * Get an iterator to a list of messages matching the supplied pattern.
            * Returns a transaction id, which is passed as an argument to the callback function.
            * It's an asynchoronous method.
            * @param {Function} callback
            *            A user-supplied callback function with the signature
            *            function({@link Iterator} of {@link MessageInfo}). The supplied function
            *            will be called asynchronously.
            * @param {MessageMatchingPattern} [matchPattern]
            *            Message matching pattern.
            * @param {SORT_BY} [sortKey]
            *            Sort key property. The value must be one of the defined sort key properties for the
            *            messaging service object
            *            (<a href=#SORT_BY_DATE>SORT_BY_DATE</a> or <a href=#SORT_BY_SENDER>SORT_BY_SENDER</a>)<br>
            *            Default is SORT_BY_DATE.
            * @param {SORT_ORDER} [sortOrder]
            *            Sorting order. The value must be one of
            *            <a href=#SORT_ASCENDING>SORT_ASCENDING</a> or <a href=#SORT_DESCENDING>SORT_DESCENDING</a>.
            *            SORT_ASCENDING is the default.
            * @param {Function} [errorCallback] This callback function gets invoked with
            * {@link DeviceError} object when error occurs in processing the async request.
            * <i>function(DeviceError)</i>
            * <i>{@link DeviceError}</i> - could be:
            * <ul>
            * <li>
            * SERVICE_BUSY_ERR: Recoverable exception when message storage unavailable/busy.<br>
            * DATA_OUT_OF_RANGE_ERR:  If any of the input parameter values are out of range.<br>
            * </li>
            * </ul>
            * @return {Number}
            *            transactionId - Unique transactionId for the request will be returned.
            * @exception {DeviceException} Code 1 (MISSING_ARG_ERR): callback is undefined.<br>
            *                              Code 2 (INVALID_ARG_ERR): <ul><li>callback is not a function</li>
            *                              <li>messageMatchingPattern  does not conform to {@link MessageMatchingPattern}</li>
            *                              <li>sortBy is not one of <a href=#SORT_BY_DATE>SORT_BY_DATE</a> or <a href=#SORT_BY_SENDER>SORT_BY_SENDER</a></li>
            *                              <li>sortOrder is not one of <a href=#SORT_ASCENDING>SORT_ASCENDING</a> or <a href=#SORT_DESCENDING>SORT_DESCENDING</a></li>
            *                              <li>errorCallback is not a function</li>
            *                              </ul>
            */
            getList: function(sCB, match, sortKey, sortOrder, eCB){
                var dummyId = 1;
                var isSync = false;
                var matchcrit = match;
    
                //new singnature is getList(match,sCB,eCB) where sCB and eCB are optional
                if(typeof sCB == 'object'){               
                  matchcrit = sCB;
                  sortKey = matchcrit.sortkey;
                  sortOrder = matchcrit.sortorder;
                  if (match != null) {
                    if(typeof match == 'function'){
                        sCB = match;
                    }else{
                       throw new DeviceException(error.INVALID_ARG_ERR, 'Messaging:getList:successCallback is not a function'); 
                    } 
                  }
                  else{
                    isSync = true;
                  } 
                  
                  if (sortKey != null) {
                    if(typeof sortKey == 'function'){
                        eCB = sortKey;
                    }else{
                       throw new DeviceException(error.INVALID_ARG_ERR, 'Messaging:getList:errorCallback is not a function');
                    } 
                  }
                }                        
                if (!isSync && (typeof sCB) != "function") {
                    throw new DeviceException(error.INVALID_ARG_ERR, 'Messaging:getList:successCallback is not a function');
                }
                if (!matchcrit) {
                    matchcrit = {};
                }
                else {
                    if ((typeof matchcrit) != "object") {
                        throw new DeviceException(error.INVALID_ARG_ERR, 'Messaging:getList:match is not an object');
                    }
                    if (matchcrit.type != null) {
                        if (typeof matchcrit.type != "object") {
                            throw new DeviceException(error.INVALID_ARG_ERR, 'Messaging:getList:invalid data type');
                        }
                    }           
                    if (matchcrit.senders != null) {
                        if (typeof matchcrit.senders != "object") {
                            throw new DeviceException(error.INVALID_ARG_ERR, 'Messaging:getList:invalid data type');
                        }               
                    }
                    if (matchcrit.subject != null) {
                        if (matchcrit.subject.length > 255) {
                            setTimeout(function(){
                                eCB(new DeviceException(error.DATA_OUT_OF_RANGE_ERR, "Messaging:getList:subject parameter is out of range"));
                            }, TIME_OUT);
                            return dummyId;
                        }
                    }
                }     
                
                if (matchcrit.priority !== null) {
                    if ((typeof matchcrit.priority) == "number" && ( matchcrit.priority < 0 || ( (matchcrit.priority % 1) != 0 ) ) ) {
                        setTimeout(function(){
                            eCB(new DeviceException(error.DATA_OUT_OF_RANGE_ERR, "Messaging:getList:priority parameter is out of range"));
                        }, TIME_OUT);
                        return dummyId;                    
                    }
                }
                
                if (matchcrit.validity !== null) {
                    if ((typeof matchcrit.validity) == "number" && ( matchcrit.validity < 0 || ( (matchcrit.validity % 1) != 0 ) ) ) {
                        setTimeout(function(){
                            eCB(new DeviceException(error.DATA_OUT_OF_RANGE_ERR, "Messaging:getList:validity parameter is out of range"));
                        }, TIME_OUT);
                        return dummyId;   
                    }
                }
    
                if (sortKey == null) 
                    sortKey = this.SORT_BY_DATE;
                else {
                    if ((typeof sortKey) != "number") {
              throw new DeviceException(error.INVALID_ARG_ERR, 'Messaging:getList:sortKey should be a number');
                    }
                    if ((typeof sortKey) == "number" && ( sortKey < 0 || sortKey > integerLimit || ( (sortKey % 1) != 0 ) ) ) {
                        setTimeout(function(){
                            eCB(new DeviceException(error.DATA_OUT_OF_RANGE_ERR, 'Messaging:getList:sortKey invalid'));
                        }, TIME_OUT); 
                        return dummyId;                   
                    }
                }
    
                if (sortOrder == null) 
                    sortOrder = this.SORT_ASCENDING;
                else {
                    if ((typeof sortOrder) != "number") {
              throw new DeviceException(error.INVALID_ARG_ERR, 'Messaging:getList:sortOrder should be a number');
                    }
                    if ((typeof sortOrder) == "number" && ( sortOrder < 0 || sortOrder > integerLimit || ( (sortOrder % 1) != 0 ) ) ) {
                        setTimeout(function(){
                            eCB(new DeviceException(error.DATA_OUT_OF_RANGE_ERR, 'Messaging:getList:sortOrder invalid'));
                        }, TIME_OUT); 
                        return dummyId;                     
                    }
                }
    
                if (eCB) {
                    if (isSync) {
                        throw new DeviceException(error.INVALID_ARG_ERR, 'Messaging:getList:synchronous call');
                    }
                    else {
                        if ((typeof eCB) != "function") 
                            throw new DeviceException(error.INVALID_ARG_ERR, 'Messaging:getList:errorCallback is not a function');
                    }
                }
    
               var matchRight = filterUndefined(matchcrit);
    
                if (!isSync) {
                  var transId  = asyncCallbackMap.add(sCB,eCB,null);
                    var returnValue = qtMessagingIf.getList(matchRight, sortKey, sortOrder, transId);
                    if (returnValue.ErrorCode != 0) {
                        asyncCallbackMap.remove(transId);
                        asyncErrorFound(returnValue, eCB);
                        return transId;
                    }
                    return transId;
                }
                else {
                    var msgIter = qtMessagingIf.getListSync(matchRight, sortKey, sortOrder);    
                    var localIter = null;
                    if (msgIter) {
                       localIter = new tempIterator(msgIter);
                        function tempIterator(tIter){
                            this.iter = tIter;
                            this.next = function(){
                                var item = this.iter.next();
                                if (item) 
                                    return item;
                                else 
                                    return null;
                            };//next
                            this.hasNext = function(){
                                return this.iter.hasNext();
                            };//hasNext
                            this.reset = function(){
                                return this.iter.reset();
                            };//reset
                            this.close = function(){
                                return this.iter.close();
                            };//close         
                        }//tempIterator   
                    }
                    return localIter;  
                }
            },
            /**
            * Get the list of configured mail accounts on the device.
            * Returns List of Account objects containing the accountId and accountName.
            * It's an synchoronous method.                   
            * @return {List}
                       List of Account objects containing the accountId and accountName.       
            */
            getEmailAccounts: function(){           
                var result = qtMessagingIf.getEmailAccounts();
                var err = result.ErrorMap;
                if(err.ErrorCode == 0){
                  var accList = result.ReturnValue;             
                  return accList;
                }else{              
                  throw new DeviceException(result.ErrorCode, result.ErrorMessage); 
                }         
            },
            
            /**
            * Get the Account object which is set as current account to do other email operations.
            * Returns Account object containing the accountId and accountName.
            * It's an synchoronous method.                
            * @return {Account}
                       Account object containing the accountId and accountName.       
            */
            getCurrentEmailAccount: function(){            
                var result = qtMessagingIf.getCurrentEmailAccount();
                var err = result.ErrorMap;
                if(err.ErrorCode == 0){
                  var acc = result.ReturnValue;             
                  return acc;
                }else{              
                  throw new DeviceException(result.ErrorCode, result.ErrorMessage); 
                }   
            },
            
            /**
            * Set the email account as the current account to do other email operations.
            * Returns void
            * It's an synchoronous method.                
            * @return 
            * @exception {DeviceException} Code 1 (MISSING_ARG_ERR): accountId is undefined.<br>
            *                              Code 2 (INVALID_ARG_ERR): <ul><li>accountId is invalid</li>          
            */
            setCurrentEmailAccount: function(accountId){
                if (!accountId) {                
                    throw new DeviceException(error.INVALID_ARG_ERR, "accountId is missing");
                }
                
                if (typeof accountId != 'string') {                
                    throw new DeviceException(error.INVALID_ARG_ERR, "accountId is not a string");
                }
                            
                var err = qtMessagingIf.setCurrentEmailAccount(accountId);            
                if(err.ErrorCode != 0){
                  throw new DeviceException(err.ErrorCode, err.ErrorMessage);
                }
            },
            
           /**  
            * Sends a message. This is an asynchronous method.
            * The message is sent to outbox.
            * @param {Function} callback
            * A user-supplied callback function. The supplied function will be called asynchronously on success.
            * A callback function with the signature
            * <i>function()</i>.
            * @param {MessageData} messageData
            *           messageData - a message that conforms to the specified message data schema.
            * @param {String} [id]
            *          Message id of another message for populating the data.
            *          Usefull in "Forward" operation.
            *          <ul>
            *          <li>
            *          Invalid to pass a MMS message id to an SMS message.
            *          </li>
            *          <li>
            *          If the SMS message id is passed to an SMS/MMS message, the message body of SMS message will be appended to the MMS message.
            *          </li>
            *          <li>
            *          If the MMS message id is passed to a MMS message, the attachments if any will be added the new MMS message. The body of the passed message will be added as an attachment.
            *          </li>
            *          </ul>
            * @param {Function} [errorCallback] This callback function gets invoked with
            * {@link DeviceError} object when error occurs in processing the async request.
            * <i>function(DeviceError)</i>
            * <i>{@link DeviceError}</i> - one of the errors:
            * <ul>
            * <li>
            * SERVICE_BUSY_ERR: Recoverable exception when message storage unavailable/busy.
            * </li>
            * <li>
            * DATA_NOT_FOUND_ERR: Recoverable exception: Sending an attachment file which is not present in the specified path.
            * </li>
            * <li>
            * URI_NOT_FOUND_ERR: Recoverable exception: If the path specified for attchment does not exist on the device.
            * </li>
            * </ul>
            *
            * @return {Number}
            *            transactionId - Unique transactionId for the request will be returned.
            * @exception {DeviceException} Code 1 (MISSING_ARG_ERR): messagedata or
            *                callback is undefined.<br>
            *                Code 2 (INVALID_ARG_ERR):
            *                                 <ul>
            *                              <li>messageData - does not conform to the specified message data schema {@link MessageData}</li>
            *                              <li>callback is not a function</li>
            *                              <li>Message id is not a <i>String</i></li>
            *                                 <li>errorCallback is not a function</li>
            *                              </ul>
            *                Code 3 (NOT_SUPPORTED_ERR):  If MMS message id is passed to SMS message            
            */
            send : function(sCB, messageData, id, eCB){
                var dummyId = 1;
                if (!sCB) {
                    throw new DeviceException(error.MISSING_ARG_ERR, 'Messaging:send:mandatory param successCallback is missing');
                }
                else if ((typeof sCB) != "function") {
                    throw new DeviceException(error.INVALID_ARG_ERR, 'Messaging:send:successCallback is not a function');
                }
                if (!messageData) {
                    throw new DeviceException(error.MISSING_ARG_ERR, 'Messaging:send:mandatory param messageData is missing');
                }
                else if ((typeof messageData) != "object") {
                    throw new DeviceException(error.INVALID_ARG_ERR, 'Messaging:send:messageData is not an object');
                }
                if (!id) {
                    id = "";
                }        
                if (((typeof id) != "function") && ((typeof id) != "string")) {
                    throw new DeviceException(error.INVALID_ARG_ERR, 'Messaging:send:id is not a string');
                }
                if ((typeof id) == "function") {
                    var errorCbk = id;
                    id = "";
                    eCB = errorCbk;
                }
                if ((typeof eCB) == "undefined" || eCB == null) {
                    eCB = null;
                }
                else if ((typeof eCB) != "function") {
                    throw new DeviceException(error.INVALID_ARG_ERR, 'Messaging:send:errorCallback is not a function');
                }
    
                if (messageData.priority !== null) {
                    if ((typeof messageData.priority) == "number" && ( messageData.priority < 0 || ( (messageData.priority % 1) != 0 ) ) ) {
                        setTimeout(function(){
                            eCB(new DeviceException(error.DATA_OUT_OF_RANGE_ERR, "Messaging:send:priority parameter is out of range"));
                        }, TIME_OUT);
                        return dummyId;   
                    }
                }
                
                if (messageData.validity !== null) {
                    if ((typeof messageData.validity) == "number" && ( messageData.validity < 0 || ( (messageData.validity % 1) != 0 ) ) ) {
                        setTimeout(function(){
                            eCB(new DeviceException(error.DATA_OUT_OF_RANGE_ERR, "Messaging:send:validity parameter is out of range"));
                        }, TIME_OUT);
                        return dummyId;  
                    }
                }
                
                var messageDataRight = filterUndefined(messageData);
                
                var toCount = 0;
                var ccCount = 0;
                
                if (messageDataRight.to && typeof messageDataRight.to == 'object') {
                    var toArray = messageDataRight.to;
                    messageDataRight.to = removeDuplicateEntry(toArray);
                    toCount = messageDataRight.to.length;
                }
                if (messageDataRight.cc && typeof messageDataRight.cc == 'object') {
                    var ccArray = messageDataRight.cc;
                    messageDataRight.cc = removeDuplicateEntry(ccArray);
                    ccCount = messageDataRight.cc.length;
                }
                
                var count = toCount+ccCount;
                var transId;
                            
                if (messageDataRight.type != "EMAIL") {
                    var dataObj = {
                        type : messageDataRight.type,
                        actualCount : count,
                        currentCount : 0
                    };
                    transId  = asyncCallbackMap.add(sCB,eCB,dataObj);
                }  
                        
                var returnValue = qtMessagingIf.send(messageDataRight, id, transId);
                if (returnValue.ErrorCode != 0) { 
                    asyncCallbackMap.remove(transId);
                    asyncErrorFound(returnValue, eCB);
                    return transId;
                }
                return returnValue.TransactionId;
            },
    
            /**
            * Registers a notifier for received messages.
            * This is asynchronous method.
            * @param {Function} callback
            *            A user-supplied callback function with signature:
            *            callback(string <i>id</i>).
            *            id is message ID to be used with, for example, getMessage(),
            *            If a notifier has already been registered, the new handler will replace it.
            *            The supplied function will be called asynchronously.
            * @param {Function} [errorCallback] This callback function gets invoked with
            * {@link DeviceError} object when error occurs in processing the async request.
            * <i>function(DeviceError)</i>
            * <i>{@link DeviceError}</i> - could be:
            * <ul>
            * <li>
            * SERVICE_BUSY_ERR: Recoverable exception when message storage unavailable/busy.
            * </li>
            * </ul>
            * @return {Number} transactionId
            *            Unique transactionId for the request will be returned.
            * @exception {DeviceException} Code 1 (MISSING_ARG_ERR): callback is undefined.<br>
            *                                 Code 2 (INVALID_ARG_ERR): <ul><li>callback is not a function</li><li>errorCallback is not a function</li></ul>
            */
            setNotifier : function(sCB, eCB){
                if (!sCB) {
                    throw new DeviceException(error.MISSING_ARG_ERR, 'Messaging:setNotifier:mandatory param successCallback is missing');
                }
                else if ((typeof sCB) != "function") {
                    throw new DeviceException(error.INVALID_ARG_ERR, 'Messaging:setNotifier:successCallback is not a function');
                }
                if ((typeof eCB) == "undefined" || eCB == null) {
                    eCB = null;
                }
                else if ((typeof eCB) != "function") {
                    throw new DeviceException(error.INVALID_ARG_ERR, 'Messaging:setNotifier:errorCallback is not a function');
                }
    
    
                if (notifyTid) {
                    asyncCallbackMap.remove(notifyTid);
                    qtMessagingIf.cancelNotifier();
                }
                notifyTid = asyncCallbackMap.add(sCB, eCB);
                var returnValue = qtMessagingIf.setNotifier(notifyTid);
                if (returnValue.ErrorCode != 0) {
            asyncCallbackMap.remove(notifyTid);
            notifyTid = null;                
                    asyncErrorFound(returnValue, eCB);
                    return;
                }
            },
    
            /**
            * Unregisters the currently set message notifier,
            * ending message notifications. This is synchronous method
            * @return {void}
            */
            cancelNotifier : function(){
                if (notifyTid) {
                    asyncCallbackMap.remove(notifyTid);
                    notifyTid = null;
                }
                var returnValue = qtMessagingIf.cancelNotifier();
                if (returnValue.ErrorCode != 0) {
                    var errMsg;
                    if (returnValue.ErrorMessage) {
                        errMsg = returnValue.ErrorMessage;
                    }
                    else {
                        errMsg = "Messaging:cancelNotifier:Operation Failed";
                    }
                    throw new DeviceException(returnValue.ErrorCode, errMsg);
                }
            },
    
            /**
            * Gets a message by id from the message store.
            * It's a synchoronous method.
            * @param {String} id
            *            of an existing message.
            *            ids can be retrieved from the notifier
            *            callback function or from messageinfo
            *            retrieved by getList()
            * @return {MessageInfo}
            *            message object that conforms to the specified message info schema {@link MessageInfo}.
            * @exception {DeviceException} Code 1 (MISSING_ARG_ERR): Id is undefined.<br>
            *                              Code 2 (INVALID_ARG_ERR): Id is not a String type.<br>
            *                              Code 101 (DATA_NOT_FOUND_ERR): Message with given id does not exist.<br>
            *                              Code 103 (SERVICE_BUSY_ERR): message storage unavailable/busy.
            *                              Code 105 (DATA_OUT_OF_RANGE_ERR): If any of the input parameter values are out of range. 
            */
            getMessage : function(messageId,folderName){
                if (!messageId) 
                    throw new DeviceException(error.MISSING_ARG_ERR, 'Messaging:getMessage:mandatory param messageId is missing');
                else if ((typeof messageId) != "string") 
                    throw new DeviceException(error.INVALID_ARG_ERR, 'Messaging:getMessage:MessageId should be a string');
                if (folderName) {
                    if(typeof folderName != "string") {
                        throw new DeviceException(error.INVALID_ARG_ERR, 'Messaging:getMessage:folderName should be a string');
                    }
                }
                else {
                    folderName = null;
                }
    
                var ret = qtMessagingIf.getMessage(messageId, folderName);
                if (ret.ErrorCode == 0) 
                    return ret.ReturnValue;
                else {
                    var errMsg;
                    if (ret.ErrorMessage) 
                        errMsg = ret.ErrorMessage;
                    else 
                        errMsg = "Messaging : getMessage :Operation Failed";
                    throw new DeviceException(ret.ErrorCode, ret.ErrorMessage);
                }
            },
    
            /**
            * Deletes a message from the message store. It's a synchoronous method.
            * It's a synchoronous method.
            * @param {String} id
            *            of an existing message.
            *            ids can be retrieved from the notifier
            *            callback function or from messageinfo
            *            retrieved by getList()
            * @return {void}
            * @exception {DeviceException} Code 1 (MISSING_ARG_ERR): id is undefined<br>
            *                              Code 2 (INVALID_ARG_ERR): id is not a string<br>
            *                              Code 101 (DATA_NOT_FOUND_ERR): message with given id does not exist.<br>
            *                              Code 103 (SERVICE_BUSY_ERR): message storage unavailable/busy.
            *                              Code 105 (DATA_OUT_OF_RANGE_ERR): If any of the input parameter values are out of range. 
            */
            deleteMessage : function(messageId){                      
                var msgDataFilter = {};
                if (!messageId){ 
                    throw new DeviceException(error.MISSING_ARG_ERR, "Missing MessageId");
                }
                if(typeof messageId == 'string'){
                    msgDataFilter.id  = messageId;
                }
                else if(typeof messageId == 'object'){
                    msgDataFilter = messageId;            
                }else{
                    throw new DeviceException(error.INVALID_ARG_ERR, "Invalid MessageId"); 
                } 
                                         
                var ret = qtMessagingIf.deleteMessage(msgDataFilter);
                if (ret.ErrorCode != 0) {
                    var errMsg;
                    if (ret.ErrorMessage) 
                        errMsg = ret.ErrorMessage;
                    else 
                        errMsg = "Messaging : deleteMessage :Operation Failed";
                    throw new DeviceException(ret.ErrorCode, ret.ErrorMessage);
                }             
            },
    
            /**
            * Sets the read/unread status of a message in the message store.
            * It's a synchoronous method.
            * @param {String} id
            *            of an existing message.
            *            ids can be retrieved from the notifier
            *            callback function or from messageinfo
            *            retrieved by getList()
            * @param {MESSAGE_STATUS} status
            *            MESSAGE_STATUS constants (<a href=#STATUS_UNREAD>STATUS_UNREAD</a>, <a href=#STATUS_READ>STATUS_READ</a>).
            * @return {void}
            * @exception {DeviceException} Code 1 (MISSING_ARG_ERR): <ul><li>id is undefined</li><li>status is undefined</li></ul>
            *                                  Code 2 (INVALID_ARG_ERR): <ul><li>id is not a string</li>status is not one of <a href=#STATUS_UNREAD>STATUS_UNREAD</a> or <a href=#STATUS_READ>STATUS_READ</a><li</li></ul>
            *                              Code 101 (DATA_NOT_FOUND_ERR): message with given id does not exist.<br>
            *                              Code 103 (SERVICE_BUSY_ERR): message storage unavailable/busy.
            *                              Code 105 (DATA_OUT_OF_RANGE_ERR): If any of the input parameter values are out of range. 
            */
            setStatus : function(messageId, status){
                if (!messageId) {
                    throw new DeviceException(error.MISSING_ARG_ERR, 'Mandatory parameter messageId missing');
                }
                else if ((typeof messageId) != "string") {
                    throw new DeviceException(error.INVALID_ARG_ERR, 'messageId should be a string');
                }
                if (status == null) {
                    throw new DeviceException(error.MISSING_ARG_ERR, 'Mandatory parameter status missing');
                }
                else {
                    if ((typeof status) != "number") {
                        throw new DeviceException(error.INVALID_ARG_ERR, 'status should be a number');
                    }
                    if ((typeof status == "number") && ( status < 0 || status > integerLimit || ( (status % 1) != 0 ) ) ) 
                        throw new DeviceException(error.DATA_OUT_OF_RANGE_ERR, 'invalid value for status');
                }
                var ret = qtMessagingIf.setStatus(messageId, status);
                if (ret.ErrorCode != 0) {
                    var errMsg;
                    if (ret.ErrorMessage) 
                        errMsg = ret.ErrorMessage;
                     else 
                        errMsg = "Messaging : setStatus :Operation Failed";
                     throw new DeviceException(ret.ErrorCode, errMsg);              
                 }          
            },
    
            /**
            * Cancels any asynchronous request identified uniquely by trasactionId.
            * It's a synchoronous method.
            * @param {Number} transactionId
            * @exception {DeviceException} Code 1 (MISSING_ARG_ERR): transactionId is undefined.<br>
            *                              Code 2 (INVALID_ARG_ERR): transactionId is not a number.<br>
            *                              Code 101 (DATA_NOT_FOUND_ERR): transactionId does not match with a asynchronous request.
            * @return {void}
            */
            cancel : function(transactionId){
                if (transactionId == null) {
                    throw new DeviceException(error.MISSING_ARG_ERR, 'Messaging:cancel:mandatory param transactionId is missing');
                }
                else if ((typeof transactionId) != "number") {
                    throw new DeviceException(error.INVALID_ARG_ERR, 'Messaging:cancel:transactionId is not a number');
                }
    
                var errMsg;
                asyncCallbackMap.remove(transactionId);
                var returnValue = qtMessagingIf.cancel(transactionId);
                if (returnValue.ErrorCode != 0) {
                    if (returnValue.ErrorMessage) {
                        errMsg = returnValue.ErrorMessage;
                    }
                    else {
                        errMsg = "Messaging:cancel:Operation Failed";
                    }             
                    throw new DeviceException(returnValue.ErrorCode, errMsg);
                }
        }  
    };
}




