/**
 * @author 
 */
/**
 * @class
 */

nokia.device.Geolocation = function PSGeoLocation(){
    function PositionError()
	{
		this.UNKNOWN_ERROR = 0;
		this.PERMISSION_DENIED = 1;
		this.POSITION_UNAVAILABLE = 2;
		this.TIMEOUT = 3;
		this.code ;
		this.message ;
	}
	function Coordinates()
	{
		this.latitude = null;
		this.longitude = null;
		this.altitude = null;
		this.accuracy = null;
		this.altitudeAccuracy = null;
		this.heading = null;
		this.speed = null;
	}
	function Position()
	{
		this.coords = null;
		this.timestamp = null;
	}
	function PositionOptions()
	{
		this.enableHighAccuracy ;
		this.timeout;
		this.maximumAge;
	}
	function errorObject()
	{
		this.ErrArgument = -6;
		this.ErrNotSupported = -5;
		this.ErrInUse = -14;
		this.ErrAccessDenied = -21;
		this.ErrNotFound = -1;
		this.ErrGeneral = -2;
		this.ErrDeviceNotReady = -18;
	}
	function convertToCjseError(cjseError)
	{
		var locException = new nokia.device.DeviceException(0,"");
		var errObject = new Object();
		switch(cjseError){
			case this.ErrArgument:
				errObject.code = locException.INVALID_ARG_ERR;
				errObject.message ="one of the argument supplied is not proper";
				break;
			case this.ErrNotSupported:
				errObject.code = locException.NOT_SUPPORTED_ERR;
				errObject.message ="requested service not supported";
				break;
			case this.ErrInUse:
				errObject.code = locException.SERVICE_IN_USE_ERR;
				errObject.message ="requested service is already in use";
				break;	
			case this.ErrDeviceNotReady:
				errObject.code = locException.NOT_ALLOWED_ERR;
				errObject.message ="service not ready";
				break;	
			default:
				errObject.code = -101;
				errObject.message = "unknown";									
				
		}
		return errObject;
	}
	function __sp_location_handle_error(errorCallback,errorCode)
	{
		if( (errorCallback != undefined) && (typeof errorCallback == 'function') && (errorCallback != null) )
		{
			//create a new position error object
			var posError = new PositionError(); 
			if( (-21) == errorCode )
			{
				posError.code = posError.PERMISSION_DENIED;
				posError.message = "permission denied";
				
			}
			else if( (-33) == errorCode )
			{
	
				posError.code = posError.TIMEOUT;
				posError.message = "request timed out";
	
				
			}
			else 
			{
				posError.code = posError.UNKNOWN_ERROR;
				posError.message = "UnKnown Error";
				
			}
			
			//Invoke user supplied error callback
			errorCallback( posError );
			
		} else {
			var posError = new PositionError();
			posError.code = posError.UNKNOWN_ERROR;
			posError.message = "UnKnown Error";
			throw posError;
		}
		
		
		
	}
	function isInputValid(__pos_opt)
	{
		////alert("input validation starts");
		////alert("typeofinp="+typeof(__pos_opt));
		
		var isValid = true;
		//special check for  0
		if ((__pos_opt !== undefined)
		    && (typeof(__pos_opt) === "number")) {
			return false;
		}
		if ((__pos_opt === undefined) 
		    ||(__pos_opt === null)
			||(__pos_opt === "")) {
				
			return true;
		}
		if((typeof(__pos_opt) != "object")) {
			return false;	
		} 
			
		////alert("object check ok");		
		
		if((__pos_opt.enableHighAccuracy !== undefined ))
		{
			if ((__pos_opt.enableHighAccuracy === null) || (__pos_opt.enableHighAccuracy === "")) {
				if(typeof(__pos_opt.enableHighAccuracy) != "number") {
					isValid =  true;
				}	
			} else 
			{
				if (typeof(__pos_opt.enableHighAccuracy) != "boolean") {
					return false;
				}
			}
			
		}
		////alert("accuracy ok");
			
		if (__pos_opt.timeout !== undefined) {
			if ((__pos_opt.timeout === null)
			    || ((__pos_opt.timeout === ""))) {
					
				isValid =  true;	
				
			}
			else if (typeof(__pos_opt.timeout) != "number")
				return false;
			else if(isNaN(__pos_opt.timeout) || (__pos_opt.timeout == Infinity))
				return false;
		}
		////alert("TO ok");
		if (__pos_opt.maximumAge !== undefined) {
			if ((__pos_opt.maximumAge === null)
			    || ((__pos_opt.maximumAge === ""))) {
					
				isValid =  true;	
				
			}
			else if (typeof(__pos_opt.maximumAge) != "number")
				return false;
			else if(isNaN(__pos_opt.maximumAge)|| (__pos_opt.maximumAge == Infinity))
				return false;
		}
		
		////alert("all ok exiting validation");
		return isValid;
		   
	}
	function watchIndex()
	{
		this.watchId;
		this.connectId;
	}
	var watchArray = new Array();
	
   /**
    * Internal
    * Geolocation interface object.
    */

    var qtGeolocationIf = nokia._services.load("nokia.device.geolocation", "com.nokia.ILocation", "1.0");
		var locException = new nokia.device.DeviceException(0,"");
		var asyncReqObj = asyncCallbackMap;
		var connectId = qtGeolocationIf.addEventListener("MethodAsyncCallback(int,int,const QMap<QString,QVariant>&,QString)",__CJSE_CALLBACK);
        if (connectId < 0) {
            throw ("Connect Failed:" + connectId);
        }
	
    function __CJSE_CALLBACK(id1, id2, id3,mName){
		//alert("inside PS Location callback");
		var retObj = asyncReqObj.get(id2);
		asyncReqObj.remove(id2);
		
		if (!retObj) {
            //alert('asyncReqObj.get error');
            return;
        }
		var callback = retObj.success_cb;
        var errCbk = retObj.error_cb;
		
		if(id1 != 0) {
			//alert("pf error code="+id1);
			//qtGeolocationIf.removeEventListener(connectId);
			//alert("listener removed");
			
			if (errCbk) {
				var errObj = convertToCjseError(id1);
				var errObj =  new nokia.device.DeviceAPIError(errObj.code,errObj.message);
				if (errCbk){
					errCbk(errObj,mName);	
				}
				
			}
			
		}
		else {
			//alert("inside pf scb");
			//alert("creating _pos_coord");
			var _pos_coord = new Coordinates();
			//alert("longitude="+id3.longitude);
			if(id3.longitude && !isNaN(id3.longitude)){
				_pos_coord.longitude = id3.longitude;
			}
			//alert("latitude="+id3.latitude);
			if(id3.latitude && !isNaN(id3.latitude)){
				_pos_coord.latitude = id3.latitude;
			}
			//alert("altitude="+id3.altitude);
			if(id3.altitude && (!isNaN(id3.altitude))){
				_pos_coord.altitude = parseFloat(id3.altitude);
			}
			
			if(id3.accuracy && (!isNaN(id3.accuracy))){
				_pos_coord.accuracy = parseFloat(id3.accuracy);
			}
			
			if(id3.altitudeAccuracy ){
				if(!isNaN(id3.altitudeAccuracy)){
					_pos_coord.altitudeAccuracy = parseFloat(id3.altitudeAccuracy);	
				}
					
				
			}
			//alert("creating position object");
			//Position Object
			var _pos_data = new Position();
			_pos_data.coords = new Object();
			
			_pos_data.coords =_pos_coord;
			//alert("time="+id3.timestamp);
			if(id3.timestamp){
				_pos_data.timestamp = id3.timestamp;
			}
			
			
			//qtGeolocationIf.removeEventListener(connectId);
			//Invoke consumer callback
			//alert("ps callback longitude="+_pos_data.coords.longitude);
			//alert("callback set="+callback);
			//alert("cjse methodname="+id3.methodname)
			callback( _pos_data,mName );
		}
	}
    return {
        /**
        * @constant {String} 
        * interfaceName.
        */      
        interfaceName: "geolocation",
        /**
        * @constant {Number} 
        * version.
        */      
        version: nokia.device._interfaces['geolocation'],
	    /**
	     * Gets the current position of the hosting device.
	     * This is an asynchronous API.
	     * <br><br>
	     * @param {function} callback A callback function with the signature
	     *                     <i>function({@link Position} )</i>
	     *                     Position contains location coordinate in WGS-84 representation
	     *                     as well as time stamp when this coordinate was obtained.
	     * @param {function} [errorCallback] This callback function is optional and when supplied gets invoked with
	     * {@link PositionError} object when error occurs in processing the  request.
	     * @param {object} [__pos_opt] optional position option see {@link PositionOptions} for details
	     * @return none
	     * @exception  					Code 0 (UNKNOWN_ERROR): Parametrs supplied are invalid and error callback is not supplied 
	     *                              or is invalid.
	     *                              <br>
	     *                              
	     */
		getPositionUsingMethodName : function (callback,methodName,errCbk) {
			//alert("inside cjse getmethodname");
			
			if (!callback) {
				
				throw new nokia.device.DeviceException(locException.MISSING_ARG_ERR,
													   "callback must be supplied");
				
			}
			if (typeof (callback) != "function"){
				throw new nokia.device.DeviceException(locException.INVALID_ARG_ERR,
												       "callback should be a function");
			}
			if (!methodName) {
				throw new nokia.device.DeviceException(locException.MISSING_ARG_ERR,
													   "missing method name");
			}
			if (typeof(methodName) != "string"){
				throw new nokia.device.DeviceException(locException.INVALID_ARG_ERR,
												       "methodname should be string");
			}
			if (errCbk){
				if (typeof(errCbk) != "function"){
					throw new nokia.device.DeviceException(locException.INVALID_ARG_ERR,
												       "error callback should be  function");
				}
			}
			var transId  = asyncReqObj.add(callback,errCbk,null);
			//alert("added transid="+transId);
			//connectId = qtGeolocationIf.addEventListener("AsyncCallback(int,int,const QMap<QString,QVariant>&)",__CJSE_CALLBACK);
			//alert("callback added with cid="+connectId);
			//alert("calling ps method");
			var returnValue = qtGeolocationIf.getLocationUsingMethodName(methodName,transId);
			//alert("error from ul="+returnValue.errorCode);
			if (returnValue.errorCode){
				var errObj = convertToCjseError(returnValue.errorCode);
				throw new nokia.device.DeviceException(errObj.code,errObj.message);
			}
		},
	    getCurrentPosition: function( __succes_cb, __fail_cb,__pos_opt){ 
	    	////alert("calling getcurrentposition");
			var connectId;
			if((__succes_cb == undefined) || (__succes_cb == null) || (typeof(__succes_cb) != "function"))
			{
				__sp_location_handle_error(__fail_cb,-1);
				//alert("succes_cb fail");
				
			}
			if ((__fail_cb != undefined)) {
				if ((__fail_cb != null)
				    &&(__fail_cb != "")
					&& (typeof(__fail_cb) != "function")) {
						//alert("fail_cb fail");
					var errorObject = new PositionError();
					errorObject.code = -1;
					throw errorObject;	
				}
			}
			////alert("pos object:TO="+__pos_opt);
			/**
			 * following code handles situation where timeout = 0 and maximumAge is 
			 * either not supplied or supplied as 0.
			 */
			if ((__pos_opt != undefined) 
			    && (__pos_opt != null)
				&& (__pos_opt != "")
				&& (typeof(__pos_opt) == "object")
				&& (__pos_opt.timeout != undefined)) {
				if ((__pos_opt.timeout == 0) && (typeof(__pos_opt.timeout) == "number")) {
					if ((__pos_opt.maximumAge == undefined)
					|| (__pos_opt.maximumAge == 0)) {
						//alert("time out error");
					    var errorObject = new PositionError();
						errorObject.code = 3;
						errorObject.message = "time out error";
						if ((__fail_cb != undefined) && (typeof(__fail_cb) == "function")) {
							__fail_cb(errorObject);
							return;
						}else {
							throw errorObject;	
						}
						
					}
				}
				
			}
			////alert("typeoffunction="+typeof(__succes_cb));
			var serviceObject = qtGeolocationIf;
			function __location_cb(id1,id2,id3)
			{
				//this.locationservice.removeEventListener(connectId);
				if(id1 != 0) //handle error
				{
					//alert("Pf error");
					serviceObject.removeEventListener(connectId);
					__sp_location_handle_error(__fail_cb,id1);
				}
				else
				{
					var _pos_coord = new Coordinates();
					_pos_coord.longitude = (id3.longitude == undefined)?null:id3.longitude;
					_pos_coord.latitude = (id3.latitude == undefined)?null:id3.latitude;
					_pos_coord.altitude = (id3.altitude == undefined)?null:id3.altitude;
					_pos_coord.accuracy = (id3.accuracy == undefined)?null:id3.accuracy;
					_pos_coord.altitudeAccuracy = (id3.altitudeAccuracy == undefined)?null:id3.altitudeAccuracy;
					_pos_coord.heading = (id3.heading == undefined)?null:id3.heading;
					_pos_coord.speed = (id3.speed == undefined)?null:id3.speed;
					
					//Position Object
					var _pos_data = new Position();
					_pos_data.coords = new Object();
					_pos_data.coords =_pos_coord;
					
					_pos_data.timestamp = id3.timestamp;
					serviceObject.removeEventListener(connectId);
					//Invoke consumer callback
					__succes_cb( _pos_data );
				}
			}
			////alert("inside actual function call");
			//add callback to the event listener
			connectId = qtGeolocationIf.addEventListener("AsyncCallback(int,int,const QMap<QString,QVariant>&)",__location_cb);
			////alert("conncetid="+connectId);
		    var returnValue;
			if((__pos_opt != undefined) && (__pos_opt != null) ) 
			{
				////alert("posoptdefined="+__pos_opt);
				//input validation
				////alert("result="+(__pos_opt.maximumAge == Infinity));
				if((__pos_opt.maximumAge == Infinity))
				{
					if((__pos_opt.enableHighAccuracy == undefined) || 
					   (typeof(__pos_opt.enableHighAccuracy) == "boolean"))
					{
						////alert("calling getlast1");
						var posOpts = new Object();
						var lastKnownLocation = new Boolean(true);
						returnValue = qtGeolocationIf.getCurrentPosition(posOpts,lastKnownLocation);
						if(returnValue.errorCode < 0)
						{
							//alert("return error");
							qtGeolocationIf.removeEventListener(connectId);
							////alert("errCode:lib="+returnValue.errorCode);
							__sp_location_handle_error(__fail_cb,returnValue.errorCode);
							return;
							
						}
						return;
						
					}
					else
					{
						qtGeolocationIf.removeEventListener(connectId);
						__sp_location_handle_error(__fail_cb,-1);
						return;
					    
						
					}
					
				}
				var isValid = isInputValid(__pos_opt);
				//alert("isValid="+isValid);
				if(isValid)
				{
					var getLast = new Boolean(false);
					//alert("calling PS API");
					returnValue = qtGeolocationIf.getCurrentPosition(__pos_opt,getLast);		
					
					
								
				}
				else //handle error
				{
					qtGeolocationIf.removeEventListener(connectId);
					__sp_location_handle_error(__fail_cb,-1);
					return;
					
				}
				
			}
			else
			{
				////alert("posoptundef="+__pos_opt);
				var posOpts = new Object();
				var getLastlocation = new Boolean(false);
				returnValue = qtGeolocationIf.getCurrentPosition(posOpts,getLastlocation);
				////alert("retvalue="+returnValue);
			}
			 
			if(returnValue.errorCode < 0)
			{
				//alert("PF retvalue error");
				__sp_location_handle_error(__fail_cb,returnValue.errorCode);
				qtGeolocationIf.removeEventListener(connectId);
				return;
			}
	    
	    	
	    
	    
	    },
		/**
	     * Notify about updates of the hosting device position.
	     * Invokes __succes_cb whenever device positon changes.
	     * This is an asynchronous API.
	     * <br><br>
	     * @param {function} callback A callback function with the signature
	     *                     <i>function({@link Position} )</i>
	     *                     Position contains location coordinate in WGS-84 representation
	     *                     as well as time stamp when this coordinate was obtained.
	     * @param {function} [errorCallback] This callback function is optional and when supplied gets invoked with
	     * {@link PositionError} object when error occurs in processing the  request.
	     * @param {object} [__pos_opt] optional position option see {@link PositionOptions} for details
	     * @return an integer value that uniquely identifies the watch process. When the clearWatch() method is called 
	     * 	with this identifier, the watch process must stop acquiring any new position fixes and must cease invoking any callbacks.
	     * @exception  					Code 0 (UNKNOWN_ERROR): Parametrs supplied are invalid and error callback is not supplied 
	     *                              or is invalid.
	     *                              <br>
	     *                              
	     */
	    watchPosition: function( __succes_cb, __fail_cb,__pos_opt){ 
	   
	    	var connectId;
			////alert("TO="+__pos_opt.timeout);
			////alert("maxage="+__pos_opt.maximumAge);
			if((__succes_cb == undefined) || (__succes_cb == null) || (typeof(__succes_cb) != "function"))
			{
				__sp_location_handle_error(__fail_cb,-1);
				
			}
			if ((__fail_cb != undefined)) {
				if ((__fail_cb != null)
				    &&(__fail_cb != "")
					&& (typeof(__fail_cb) != "function")) {
					var errorObject = new PositionError();
					errorObject.code = -1;
					throw errorObject;	
				}
			}
			if ((__pos_opt != undefined) 
			    && (__pos_opt != null)
				&& (__pos_opt != "")
				&& (typeof(__pos_opt) == "object")
				&& (__pos_opt.timeout != undefined)) {
				if ((__pos_opt.timeout == 0) && (typeof(__pos_opt.timeout) == "number")) {
					if ((__pos_opt.maximumAge == undefined)
					|| (__pos_opt.maximumAge == 0)) {
						//alert("imeout 0 case");
					    var errorObject = new PositionError();
						errorObject.code = 3;
						errorObject.message = "time out error";
						if ((__fail_cb != undefined) && (typeof(__fail_cb) == "function")) {
							__fail_cb(errorObject);
							return;
						}else {
							throw errorObject;	
						}
						
					}
				}
				
				if ((__pos_opt.timeout >= 86400000) && (typeof(__pos_opt.timeout) == "number")) {
					//alert(" My condition"+__pos_opt.timeout);
					__pos_opt.timeout = 86400000;
				}
			}
			if ((__pos_opt != undefined)) {
				if ((__pos_opt != null)
				    &&(__pos_opt != "")
					&& (typeof(__pos_opt) == "object")) {
					if ((__pos_opt.maximumAge != undefined)) {
						if ((__pos_opt.maximumAge == Infinity)) {
							//alert("maxinfinity case");
							var newPosObject = new PositionOptions();
							if ((__pos_opt.timeout !== undefined) && (__pos_opt.timeout !== 0)) 
								newPosObject.timeout = 	__pos_opt.timeout;
							if ((__pos_opt.enableHighAccuracy != undefined))
								newPosObject.enableHighAccuracy = __pos_opt.enableHighAccuracy;
							__pos_opt = newPosObject;
						}
					}	
				}
			}
			
			function __location_watch_cb(id1,id2,id3)
			{
				
				if(id1 != 0) //handle error
				{
					__sp_location_handle_error(__fail_cb,id1);
				}
				else
				{
					var _pos_coord = new Coordinates();
					_pos_coord.longitude = (id3.longitude == undefined)?null:id3.longitude;
					_pos_coord.latitude = (id3.latitude == undefined)?null:id3.latitude;
					_pos_coord.altitude = (id3.altitude == undefined)?null:id3.altitude;
					_pos_coord.accuracy = (id3.accuracy == undefined)?null:id3.accuracy;
					_pos_coord.altitudeAccuracy = (id3.altitudeAccuracy == undefined)?null:id3.altitudeAccuracy;
					_pos_coord.heading = (id3.heading == undefined)?null:id3.heading;
					_pos_coord.speed = (id3.speed == undefined)?null:id3.speed;
					
					//Position Object
					var _pos_data = new Position();
					_pos_data.coords = new Object();
					_pos_data.coords =_pos_coord;
					
					_pos_data.timestamp = id3.timestamp;
					
					
					//Invoke consumer callback
					__succes_cb( _pos_data );
				}
			}
			////alert("inside actual trace function call");
			//add callback to the event listener
			connectId = qtGeolocationIf.addEventListener("AsyncCallback(int,int,const QMap<QString,QVariant>&)",__location_watch_cb);
			////alert("watchid="+connectId);
		    var returnValue;
			if((__pos_opt != undefined) && (__pos_opt != null) ) 
			{
				var isValid = isInputValid(__pos_opt);
				//alert("isvalid="+isValid);
				if(isValid)
				{
					returnValue = qtGeolocationIf.watchPosition(__pos_opt);
				}
				else
				{
					qtGeolocationIf.removeEventListener(connectId);
					__sp_location_handle_error(__fail_cb,-1);
					return;
				}
				
				
			}
			else
			{
				var posOpts = new Object();
				returnValue = qtGeolocationIf.watchPosition(posOpts);
			}
			 
			if(returnValue.errorCode < 0)
			{
				qtGeolocationIf.removeEventListener(connectId);
				__sp_location_handle_error(__fail_cb,returnValue.errorCode);
				
				return;
			}
			else
			{
				var callbackinfo = new watchIndex();
				callbackinfo.connectId = connectId;
				callbackinfo.watchId = returnValue.transactionId;
				watchArray.push(callbackinfo);
				return returnValue.transactionId;	
			}
			    
			    
			    
		},
		/**
		 * Clears previously invoked watchPosiion request
		 * @param {integer}  Uniqely  Identifies previously invoked watchPosition Request.
		 * @return none
		 * @exception when supplied with an invalid type of id or not supplied with anything at all.
		 */
		clearWatch: function(watchId) {
			//////alert("inside clearwatch");
			if((isNaN(watchId)) || watchId == undefined || watchId == null)
			throw "invalid or Missing watchId";
			else
				{
					for (var d in watchArray)
					{
						if(watchArray[d].watchId == watchId)
							{
							//////alert("cancel.connectId="+watchArray[d].connectId);
							qtGeolocationIf.removeEventListener(watchArray[d].connectId);
							qtGeolocationIf.clearWatch(watchArray[d].watchId );
							//remove the entry from watch table
							watchArray.splice(d,1);
							}
					}
				
				
				}
			
		}
   		 
    };
}
