#!/usr/bin/perl
use Cwd;
use File::Path;
use File::Copy;

#constants
use constant CONFIG_FILE_PATH   => '/config/config.conf';
use constant PROVIDER           => 'PROVIDER';
use constant WGZ_PATH           => 'WGZ_PATH';
use constant WGT_PATH           => 'WGT_PATH';
use constant TMP_PATH           => 'TMP_PATH';
use constant REL_PATH           => 'REL_PATH';

use constant FRAMEWORK_JS       => 'FRAMEWORK_JS';
use constant COMBINED_JS        => 'COMBINED_JS';
use constant TESTTREE_JS        => 'TESTTREE_JS';
use constant DEVICE_JS          => 'DEVICE_JS';

use constant TRUE               => 1;
use constant FALSE              => 0;

%options = (
    'cleanup'   => \&cmdCleanup,
    'widgets'   => \&cmdWidgets,
    'merge'     => \&cmdMerge,
    'maemo'     => \&cmdMaemo,
    'maemo-new' => \&cmdMaemoNew,
    's60-new'   => \&cmdS60New 
);

#variables
@providers = ();
$ziptool = "7z a -tzip ";
$compress = TRUE;
$emptypsfile = FALSE;
readConfig();

$option = shift;
if( length($option) > 0 )
{
    while( length($option) > 0 ) {
        if( defined $options{$option} ) {
            $options{$option}->();
        }
        
        $option = shift;
    }
}
else { 
    cleanup();
    merge();
    widgets();
}

#parse the input options
$option = shift;
while( length($option) > 0 )
{
    if( defined $options{$option} ) {
        $options{$option}->();
    }
    
    $option = shift;
}

sub cmdMaemo()
{
    $ziptool = "zip ";
    $compress = FALSE;
    $emptypsfile = FALSE;
    cleanup();
    merge();
    widgets();
}

sub cmdMaemoNew()
{
    $ziptool = "zip ";
    $compress = FALSE;
    $emptypsfile = TRUE;
    cleanup();
    merge();
    widgets();
}

sub cmdS60New()
{
    $ziptool = "7z a -tzip ";
    $compress = FALSE;
    $emptypsfile = TRUE;
    cleanup();
    merge();
    widgets();
}

sub readConfig()
{
    # This piece of code will get the physical path of this script
    # irrespective of from where this script is executed.
    use File::Spec::Functions qw(rel2abs);
    use File::Basename;
    
    $path = dirname(rel2abs($0));
    
    my $configfile = $path . CONFIG_FILE_PATH;
    
    my %config;
    open my $config, '<', $configfile or die $!;
    
    while (<$config>) {
        chomp;                  # no newline
        s/#.*//;                # no comments
        s/^\s+//;               # no leading white
        s/\s+$//;               # no trailing white
        next unless length;     # anything left?
        my ($var, $value) = split(/\s*=\s*/, $_, 2);
        if( exists $User_Preferences{$var} )
        {
            $User_Preferences{$var} = $User_Preferences{$var} . ' ' . $value;
        }
        else
        {
            $User_Preferences{$var} = $value;
        }
    }
    
    if( exists $User_Preferences{PROVIDER})
    {
        @providers = split(' ', $User_Preferences{PROVIDER});
    }
}

sub cmdCleanup()
{
    cleanup();
}

sub cleanup()
{
    rmtree( $path . $User_Preferences{WGT_PATH} );
    rmtree( $path . $User_Preferences{WGZ_PATH} );
    rmtree( $path . $User_Preferences{TMP_PATH} );
#    rmtree( $path . $User_Preferences{UNC_PATH} );
    
    $jspath = $path . $User_Preferences{REL_PATH};
    
    opendir(DIR, $jspath) or die "Can't Open Directory $dirname: $!";
    while( $file = readdir(DIR)  ) {
        next if( rindex($file, ".js") == -1 );
        if( rindex( $path . $User_Preferences{REL_PATH} . "/" . $User_Preferences{FRAMEWORK_JS}, $file) == -1 ) {
            unlink($jspath ."/".$file);
            }
    }
    closedir(DIR);
    
    foreach $provider(@providers) {
        $widgetsdir = $path . $User_Preferences{TESTASSET_PATH} . "/". $provider . "/tsrc";
        opendir(WIDGETSDIR, $widgetsdir) || next;
        @widgets = readdir(WIDGETSDIR);
        foreach $widget(@widgets) {
            next if ($widget =~ m/^\./);
            $widgetpath = $widgetsdir . "/" . $widget;
            if( -d $widgetpath ) {
                $wgzfiles = '';
                $wgtfiles = '';
                unlink($widgetpath . "/" . $User_Preferences{COMBINED_JS});
                unlink($widgetpath . "/" . $User_Preferences{TESTTREE_JS});
            }
        }  
        closedir(WIDGETSDIR);
    }
}    
   
sub cmdMerge()
{
    cleanup();
    merge();
}

sub merge()
{
    # First merge all the individual modules into single module js file
    foreach $provider(@providers) {
        $providerjspath = $path . "/" . $provider;
        
        opendir(DIR, $providerjspath );
        my $tmpfile =  ">" . $path . $User_Preferences{REL_PATH} . "/" . $provider . ".js";
        open PROVIDER_JS_FILES, $tmpfile or die $!; 
        while( $file = readdir(DIR) )
        {
            next if( rindex($file, ".js") == -1 );
            open (PROVIDERFILE, $providerjspath . "/" . $file);
            while (<PROVIDERFILE>) {
                chomp;
                print PROVIDER_JS_FILES "$_\n";                
           }
            close (PROVIDERFILE);
        }
        closedir(DIR);
        close PROVIDER_JS_FILES;
        
        #@files = <$providerjspath/*>;
        #
        #
        #my $tmpfile =  ">" . $path . $User_Preferences{REL_PATH} . "/" . $provider . ".js";
        #open PROVIDER_JS_FILES, $tmpfile or die $!; 
        #foreach $file (@files) {
        #    open (PROVIDERFILE, $file);
        #    while (<PROVIDERFILE>) {
        #        chomp;
        #        print PROVIDER_JS_FILES "$_\n";
        #    }
        #    close (PROVIDERFILE);
        #    #print PROVIDER_JS_FILES "$file\n"; 
        #    }
        #close PROVIDER_JS_FILES;
        #system "java -jar $path/tools/JsCombine.jar $path/temp/$provider.txt $path/release/$provider.js > $path/temp/$provider.log";
    }

    my $combinedjs = ">" . $path . $User_Preferences{REL_PATH} . "/" . $User_Preferences{COMBINED_JS};
    open COMBINED_JS_FILE, $combinedjs or die $!;
    open FRAMEWORK_JS_FILE, $path . $User_Preferences{REL_PATH} . "/" . $User_Preferences{FRAMEWORK_JS} ;
    while(<FRAMEWORK_JS_FILE>) {
        print COMBINED_JS_FILE "$_";
    }
    close FRAMEWORK_JS_FILE;
    
    $jspath = $path . $User_Preferences{REL_PATH};
    @jsfiles = ();
    opendir(DIR, $jspath) or die "Can't Open Directory $dirname: $!";
    while( $file = readdir(DIR)  ) {
        next if( rindex($file, ".js") == -1 );
        if( rindex( $path . $User_Preferences{REL_PATH} . "/" . $User_Preferences{FRAMEWORK_JS}, $file) == -1 &&
            rindex( $path . $User_Preferences{REL_PATH} . "/" . $User_Preferences{COMBINED_JS}, $file) == -1 ) {
            push(@jsfiles, $file );
        }
    }
    closedir(DIR);
    @jsfiles = sort( @jsfiles );
    foreach $file(@jsfiles) {
        open JS_FILE , $jspath . "/" . $file ;
        while(<JS_FILE>) {
            print COMBINED_JS_FILE "$_";
        }
        close JS_FILE;
    }
    close COMBINED_JS_FILE;

    if( $compress == TRUE )
    {
#        rmtree( $path . $User_Preferences{UNC_PATH} );
#        mkdir( $path . $User_Preferences{UNC_PATH} );
        foreach $provider(@providers) {
           copy( $path . $User_Preferences{REL_PATH} . "/" . $provider . ".js" , $path . $User_Preferences{UNC_PATH} . "/" . $provider . ".js");
           unlink( $path . $User_Preferences{REL_PATH} . "/" . $provider . ".js" );
           open EMP_MODULE, ">", $path . $User_Preferences{REL_PATH} . "/" . $provider . ".js"; 
           close EMP_MODULE;
        }
        copy( $path . $User_Preferences{REL_PATH} . "/" . $User_Preferences{COMBINED_JS} , $path . $User_Preferences{UNC_PATH} . "/" . $User_Preferences{COMBINED_JS});
        copy( $path . $User_Preferences{REL_PATH} . "/" . $User_Preferences{COMBINED_JS} , $path . $User_Preferences{UNC_PATH} . "/" . $User_Preferences{DEVICE_JS});
        system("java -jar $path/tools/custom_rhino.jar -c $path$User_Preferences{REL_PATH}/$User_Preferences{COMBINED_JS} > $path$User_Preferences{REL_PATH}/$User_Preferences{DEVICE_JS}");
	      copy( $path . $User_Preferences{REL_PATH} . "/" . $User_Preferences{DEVICE_JS}, $path . $User_Preferences{REL_PATH} . "/" . $User_Preferences{COMBINED_JS} );
    } 
    else
    {
        copy( $path . $User_Preferences{REL_PATH} . "/" . $User_Preferences{COMBINED_JS}, $path . $User_Preferences{REL_PATH} . "/" . $User_Preferences{DEVICE_JS} );
    }
    
    if( $emptypsfile == TRUE ) {
        unlink( $path . $User_Preferences{REL_PATH} . "/" . $User_Preferences{COMBINED_JS} );
        open EMPTYFILE, ">", $path . $User_Preferences{REL_PATH} . "/" . $User_Preferences{COMBINED_JS};
        close EMPTYFILE;
    }    
}
   
sub cmdWidgets()
{
    cleanup();
    widgets();
} 

sub widgets()
{
    $wgtpath = $path . $User_Preferences{WGT_PATH};
    $wgzpath = $path . $User_Preferences{WGZ_PATH};
    mkdir( $path . $User_Preferences{TMP_PATH} );
    mkdir( $wgtpath );
    mkdir( $wgzpath );
    foreach $provider(@providers) {
        $widgetsdir = $path . $User_Preferences{TESTASSET_PATH} . "/". $provider . "/tsrc";
        opendir(WIDGETSDIR, $widgetsdir) || next;
        @widgets = readdir(WIDGETSDIR);
        foreach $widget(@widgets) {
            next if ($widget =~ m/^\./);
            $widgetpath = $widgetsdir . "/" . $widget;
            if( -d $widgetpath )
            {
                $wgzfiles = '';
                $wgtfiles = '';
# removing copying of platformservices.js to test widgets
#                copy($path . $User_Preferences{REL_PATH} . "/" . $User_Preferences{COMBINED_JS}, $widgetpath );
                copy($path . $User_Preferences{TST_PATH} . "/" . $User_Preferences{TESTTREE_JS}, $widgetpath );
                
                opendir( WIDGETCONTENTS, $widgetpath);
                @widgetcontents = readdir(WIDGETCONTENTS);
                foreach $widgetcontent(@widgetcontents) {
                    next if ($widgetcontent =~ m/^\./);
                    $wgtfiles .= " $widgetcontent";
                    $wgzfiles .= " $widget/$widgetcontent";
                }
                closedir( WIDGETCONTENTS );
            }
            chdir($widgetpath);
            system("$ziptool \"$wgtpath/$widget.zip\" $wgtfiles > \"$path/$User_Preferences{TMP_PATH}/$widget.wgtlog\"  2> \"$path/$User_Preferences{TMP_PATH}/$widget.errwgtlog\"");
            rename "$wgtpath/$widget.zip","$wgtpath/$widget.wgt";
            chdir("$widgetpath/..");
            system("$ziptool \"$wgzpath/$widget.zip\" $wgzfiles > \"$path/$User_Preferences{TMP_PATH}/$widget.wgzlog\"  2> \"$path/$User_Preferences{TMP_PATH}/$widget.errwgzlog\"");
            rename "$wgzpath/$widget.zip","$wgzpath/$widget.wgz";
        }  
        closedir(WIDGETSDIR);
    }
}
