/**
 * @author thunga
 */
//ensure CJSE & QT SFW namespace are created.
if ((typeof nokia) == 'undefined') {
   /**
    * @namespace
    */
    nokia = {};
    /**
    * @namespace
    */
    nokia.device = {};
    nokia._services = {};
}
else {
    if ((typeof nokia._services) == 'undefined') {
        nokia._services = {};
    }
    if((typeof nokia._services) == 'undefined'){
        nokia.device = {};
    }
}

nokia._services = (function(){
    var error = null;
    /*
     * Implemention of nokia._services.load method 
     * 
     * @function {public object} _sfw_service_load
     * @param {string} serviceName service name of requested service
     * @param {string} interfaceName interface name of requested service
     * @param {string} version version of requested service
     * @returns service object
     */
    function _sfw_service_load(serviceName, interfaceName, version){
        //ensure qt nokia._services is been intialised.
      /*  function init_callback(){
            // Setup the nokia.factory
            nokia.factory = document.getElementById("serviceFactory");
        };
        nokia._services.init(init_callback);
        */
        var DeviceException = nokia.device.DeviceException;
        if(!error)
            error = new DeviceException('dummy',0);
        createFactoryObject();
        
        try {
            var so = nokia.factory.getServiceObject(serviceName, interfaceName);
            return so;
        }
        catch (e) {
            sfw_debug(serviceName + " " + interfaceName + " not available:"+e);
            throw new DeviceException(error.DATA_NOT_FOUND_ERR,"failed to load requested service interface, enabler not found or access restricted");
        }
    }
    
    /*
     * Implemention of the nokia._services.listServices method
     * 
     * @function {public array} _sfw_service_list
     * @returns list of registered services
     */
    function _sfw_service_list()
    {
        try {
            createFactoryObject();
            var l = nokia.factory.getServiceProviders(); 
            return l;  
        }
        catch (e){
            sfw_debug("Test service not available");
            return null;
        }
    }

    /*
     * 
     */
    function _sfw_service_init(callback) {
        try {
            createFactoryObject();
            
            // Automatically callback to client after 1 MS
            setTimeout(callback, 1 );
        }
        catch(ex) {
            sfw_debug(ex);
        }
    }
    
    /*
     * @var {bool} sfw_debug_on is ture if in debug mode
     */
    var sfw_debug_on = false;
    
    /*
     * @function {public void} sfw_debug if sfw_debug_on = true alert the input message
     * @param {string} message 
     */
    function sfw_debug(message)
    {
        if (sfw_debug_on) {
            alert(message);
        }
    }

    /*
     * Sleep for milliseconds
     * 
     * @function {public void} pausecomp
     */
    function pausecomp(millis) {
        var date = new Date();
        var curDate = null;
        do { 
            curDate = new Date(); 
        } while(curDate-date < millis);
    }
    
// Fix to improve performance in Converting QVariants to NP Objects.    
    
function __newObject(){
   return new Object();
};

function __newArray(){
   return new Array();
};

function __newDate(){
   return new Date();
};
    
    /*
     * Creates a factory object and embeds it to html file
     * 
     * @function {public object} createFactoryObject
     * @returns factory plugin 
     */
    function createFactoryObject() {
        var factory = document.getElementById("serviceFactory");
        //plugin is not embeded yet
        if (!factory) { 
            //embed plugin in a div node to html file
            var newdiv = document.createElement('div');
            newdiv.id = "factoryDiv";
            newdiv.innerHTML = '<embed  id="serviceFactory" type="application/x-sfw-plugin" height="0" hidden=true > </embed>';
            if(document.body)
               document.body.insertBefore(newdiv, document.body.firstChild);
            else
               document.getElementsByTagName('html').item(0).appendChild( newdiv );
        
            // Setup the nokia.factory
            nokia.factory = document.getElementById("serviceFactory");
	    // Call this again to execute else case
	    setTimeout(createFactoryObject, 1 );
        }
        else {
            // If the client already has the plugin embedded
            nokia.factory=factory;
            nokia.factory.SFW_CreateJSObject(__newObject,__newArray,__newDate);
        }
    }
    return{
        load : _sfw_service_load,
        listServices: _sfw_service_list,
        init:_sfw_service_init,
        version: "0.1",
        info: "Service Framework",
        factory: null       
    };
})();


//Map CJSE F/W methods to this namespace.
/**
 * The Nokia FRAMEWORK API 2.0 consists of a collection of methods, that can be
 * used to query and load available services and interfaces. 
 *
 * @namespace
 */
nokia.device = (function(){

    var cjse_interfaces = [];
    var xhr = null;
    var error = null;
    
    function getSharedLibUri(interfaceName){
        var SHARED_LIB='lib://', 
            CJSE_NS ='nokia/device/', 
            JS_EXTN ='.js';
        
        return  (SHARED_LIB+CJSE_NS+interfaceName+JS_EXTN);
    }

    function getScriptSrc(/*URI*/uri, /*Boolean*/ fail_ok){
        var DeviceException = nokia.device.DeviceException;
        var msg=null;
        
        if(!error)
            error = new DeviceException('dummy',0);

        try{
            if(!xhr)
                xhr = new XMLHttpRequest();
        }
        catch(e){
            throw new DeviceException(error.NOT_SUPPORTED_ERR,'XHr not supported');
        }
        
        try {
            xhr.open('GET', uri, false);
            xhr.send(null);
            if (xhr.status){
                msg = "XHR: Unable to GET requested inteface reason not found: " + uri + " status:" + xhr.status + xhr.responseText;
                throw new DeviceException(error.DATA_NOT_FOUND_ERR,msg);
            }
        }
        catch (e) {
            if (fail_ok) {
                return null;
            } // null
            if(e.name != 'DeviceException'){
                msg = "XHR: Unable to GET requested inteface reason not found : "+ e.message;
                throw new DeviceException(error.DATA_NOT_FOUND_ERR,msg);
            }
        }
        return xhr.responseText;
    }

    function _ps_list_interfaces(){
        function __FWIter(arr)  {
            this._arr = arr;
            this._pos = 0;
            this._valid = true;
            
            this.hasNext = function() {
                return (this._valid && this._pos < this._arr.length)
            };
            
            this.next = function() {
                if(this._valid && (this._pos < this._arr.length)){
                    return this._arr[this._pos++];
                }
                else{
                    return null;
                }
            };
            
            this.close = function(){
                delete this._arr;
                this._valid = false;
            }
        }

        if(!cjse_interfaces.length || !nokia.device._interfaces){
            var services = nokia._services.listServices();
            nokia.device._interfaces = {};
            for(i=0;i<services.length;i++)
            {
                if(services[i].toLowerCase().lastIndexOf('nokia.device.') != -1){
                    var cjse_interface = services[i].split('nokia.device.')[1];
                    var version = 0;
                    var version_txt = nokia.factory.getServiceVersion(services[i]);
                    var splits = version_txt.split('.');
                    if(splits.length>1) {
                        version = parseFloat(splits[0].concat('.'+splits[1]));
                    }else   {
                        version = parseFloat(version_txt);
                    }
                    
                    cjse_interfaces.push({name:cjse_interface,version:version});
                    nokia.device._interfaces[cjse_interface] = version;
                }
            }
        }
    
        return new __FWIter(cjse_interfaces);  
    }
    
    return{
        /**
        * @memberOf nokia.device
        * @description interfaces internal 
        */
        _interfaces: null,

        /**
        * @memberOf nokia.device
        * @constant 
        * @description Nokia FRAMEWORK API version number 
        */
        version: 2.1,
        /**
        * @memberOf nokia.device
        * @function 
        * Method loads an instance of a device service interface.
        * @param {string}    interfaceName A fully qualified name eg. contacts
        * @param {string}    version string representing the 
        * interface version number. Matches if the supported version is equal 
        * to or larger than the supplied version.
        * @return {object}   serviceObject 'so'
        */
        load: function(interfaceName, version){
            var DeviceException = nokia.device.DeviceException;
            var error = new DeviceException('dummy',0);
            
            if(interfaceName){
                if(typeof interfaceName != 'string'){
                throw new DeviceException(error.INVALID_ARG_ERR, 'nokia.device.load:Invalid type interfaceName');
                }
            }else{
                throw new DeviceException(error.MISSING_ARG_ERR, 'nokia.device.load:interfaceName param expected');
            }
            
            if(version){
                if(typeof version != 'number'){
                    throw new DeviceException(error.INVALID_ARG_ERR, 'nokia.device.load:Invalid type version');
                }
            }
            
            if (!nokia.device._interfaces){
               _ps_list_interfaces();
            }
            
            if( !(nokia.device[interfaceName]) ) {
                var scriptUri = getSharedLibUri(interfaceName);
                var scriptSrc = getScriptSrc(scriptUri);
                window.eval(scriptSrc);
            }
            return nokia.device[interfaceName];
        },
        /**
         * @memberOf nokia.device
         * @function
         * Method gets the list of the available interfaces of a given service.
         * @param {string}            interfaceName
         * @return{Iterator of InterfaceInfo}   array of InterfaceInfo  object's.
         */
        listInterfaces: _ps_list_interfaces,
        /**
         * @memberOf nokia.device
         * @function
         * Method gets the list of the available interfaces of a given service.
         * @param {string}            interfaceName
         * @return{Iterator of InterfaceInfo}   array of InterfaceInfo  object's.
         */
        getSystemProperties: function (){
        return {
                uriPath:{
                    // maximum limitation is 255 charectors
                    max:255
                }
            };
        },
        /**
         * @memberOf nokia.device
         * @function
         * Method gets javascript library version.
         * @return{Number}   Library version.
         */
        getLibraryVersion: function (){
            return 3.0;
        }
    };
})();


/**
 * A class for exceptions that Nokia JS APIs may throw,
 * DeviceException is a subclass of Error. DeviceException extends Error by adding the code property.
 * @class
 * The code proeperty of DeviceException instances store a numeric value, an error code, that represents
 * the cause of the exception. The numberic values are associated with codified strings, that may
 * be present in the message property of a DeviceException instance. 
 * <ul>
 * <li>Code range 1-49, is reserved for generic non-recoverable errors.</li>
 * <li>Code range 50-99, is reserved for domain specific non-recoverable errors. 
 *     An error code in one domain might have a different meaning in another domain.</li> 
 * <li>Code range 100-499 is reserved for generic recoverable errors.</li>
 * <li>Code range &gt;= 500 is reserved for domain specific recoverable errors. An error code in 
 *     one domain might have a different meaning in another domain.</li>
 * </ul>
 *
 * The following two tables display the error codes.
 * <br><br>
 * <b>Generic non-recoverable exception codes</b>
 * <table><tr><td>Cause</td><td>Value</td><td>Description</td></tr>
 * <tr><td>MISSING_ARG_ERR</td><td>1</td><td>If a mandatory argument in a method is missing.</td></tr>
 * <tr><td>INVALID_ARG_ERR</td><td>2</td><td>If argument pass is of different type as is expected.</td></tr>
 * <tr><td>NOT_SUPPORTED_ERR</td><td>3</td><td>In case method not available in this Interface.<br><br>
 * In case a data schema element is platform specific and a platform doesn’t support.</td></tr>
 * </table>     

 * <b>Generic recoverable exception codes</b>
 * <table><tr><td>Cause</td><td>Value</td><td>Description</td></tr>
 * <tr><td>TIMEOUT_ERR</td><td>100</td><td>This error can use when underlying implementation 
 *         could not give response with in a given time. Eg. getLocation method</td></tr>
 * <tr><td>DATA_NOT_FOUND_ERR</td><td>101</td><td>Referred data entry not found. Check UID.</td></tr>
 * <tr><td>DATA_ALREADY_EXISTS_ERR</td><td>102</td><td>Referred data entry exists already (duplicate item)</td></tr>
 * <tr><td>SERVICE_BUSY_ERR</td><td>103</td><td>Service is busy. Unable to take request now, try again later.</td></tr>
 * <tr><td>SERVICE_IN_USE_ERR</td><td>104</td><td>If user tries to register for notifications more that once. 
 *          calling traceLocation twice with calling clearTrace</td></tr>
 * <tr><td>DATA_OUT_OF_RANGE_ERR</td><td>105</td><td>If Invalid value is passed typically out of range value.</td></tr>
 * <tr><td>NOT_ALLOWED_ERR</td><td>106</td><td>If user doesn’t have permission to access specified content.
 *         Eg. DRM file or files inside private folders.</td></tr>
 * <tr><td>SIZE_EXCEEDED_ERR</td><td>107</td><td>Data exceeded allowed limits set by a platform 
 *         or by a configuration. Typically data overflow error.</td></tr>
 * <tr><td>INVALID_URI_ERR</td><td>108</td><td>Specified uri is invalid. i.e. doesn’t conform to uri schema</td></tr>
 * <tr><td>URI_NOT_FOUND_ERR</td><td>109</td><td>Specified uri refers to non existing resource.</td></tr>
 * <tr><td>URI_ALREADY_EXISTS_ERR</td><td>110</td><td>Specified uri refers to existing resource. 
 *         Typically this error code used to protect destination resource not been overwritten.</td></tr>
 * <tr><td>URI_ALREADY_EXISTS_ERR</td><td>111</td><td>Specified uri refers to existing resource. 
 *         In case device runs out of mememory while performing the operation.</td></tr>
 * </table> 
 * @param {number} code A code number for the cause of the exception.
 * @param {string} message A free-form message explaining why this exception is thrown.
 * @return DeviceException 
 */
nokia.device.DeviceException = function(code,message)    {

        /**
        * The name of the Error, will always be DeviceAPIError
        */
        this.name    = 'DeviceException';
        /**
        * A message describing the error in a human-readable way.
        */
        this.message = message;
        /**
         * Exception cause as a code number. Values in the range 1-99 indicate
         * non-recoverable errors, and values >= 100 indicate recoverable errors.
         */
        this.code    = code;
        this.MISSING_ARG_ERR            = 1;
        this.INVALID_ARG_ERR            = 2;
        this.NOT_SUPPORTED_ERR          = 3;
        this.TIMEOUT_ERR                = 100;
        this.DATA_NOT_FOUND_ERR         = 101;
        this.DATA_ALREADY_EXISTS_ERR    = 102;
        this.SERVICE_BUSY_ERR           = 103;
        this.SERVICE_IN_USE_ERR         = 104;
        this.DATA_OUT_OF_RANGE_ERR      = 105;
        this.NOT_ALLOWED_ERR            = 106;
        this.SIZE_EXCEEDED_ERR          = 107;
        this.INVALID_URI_ERR            = 108;
        this.URI_NOT_FOUND_ERR          = 109;
        this.URI_ALREADY_EXISTS_ERR     = 110;      
        this.NO_MEMORY_ERR              = 111;
        this.DIR_NOT_EMPTY_ERR          = 500;
        this.FILE_ALREADY_OPEN_ERR      = 501;
        this.URI_NOT_SUPPORTED          = 502;
        this.CONNMGR_UNKNOWN_SESSION_ERROR      = 503;
        this.CONNMGR_SESSION_ABORTED_ERROR      = 504;
        this.CONNMGR_ROAMING_ERROR              = 505;
        this.CONNMGR_OPERATION_NOTSUPPORTED_ERR = 506;
        this.CONNMGR_NO_CONFIGURATION_ERROR     = 507;
    }

nokia.device.DeviceException.prototype = new Error();

nokia.device.DeviceException.prototype.constructor = nokia.device.DeviceException;

nokia.device.DeviceException.prototype.toString = function(){
    return(this.name + " : " + this.code + " : " + this.message);
};


/**
 * A class for handling errors in errorCallback functions.
 * DeviceAPIError extends Error by adding the code property.
 * @class
 * The code proeperty of DeviceAPIError instances store a numeric value, an error code, that represents
 * the cause of the exception. The numberic values are associated with codified strings, that may
 * be present in the message property of a DeviceException instance. 
 * <ul>
 * <li>Code range 100-499 is reserved for generic recoverable errors.</li>
 * <li>Code range &gt;= 500 is reserved for domain specific recoverable errors. An error code in 
 *     one domain might have a different meaning in another domain.</li>
 * </ul>
 *
 * The following table display the error codes.
 * <b>Generic recoverable exception codes</b>
 * <table><tr><td>Cause</td><td>Value</td><td>Description</td></tr>
 * <tr><td>TIMEOUT_ERR</td><td>100</td><td>This error can use when underlying implementation 
 *         could not give response with in a given time. Eg. getLocation method</td></tr>
 * <tr><td>DATA_NOT_FOUND_ERR</td><td>101</td><td>Referred data entry not found. Check UID.</td></tr>
 * <tr><td>DATA_ALREADY_EXISTS_ERR</td><td>102</td><td>Referred data entry exists already (duplicate item)</td></tr>
 * <tr><td>SERVICE_BUSY_ERR</td><td>103</td><td>Service is busy. Unable to take request now, try again later.</td></tr>
 * <tr><td>SERVICE_IN_USE_ERR</td><td>104</td><td>If user tries to register for notifications more that once. 
 *          calling traceLocation twice with calling clearTrace</td></tr>
 * <tr><td>DATA_OUT_OF_RANGE_ERR</td><td>105</td><td>If Invalid value is passed typically out of range value.</td></tr>
 * <tr><td>NOT_ALLOWED_ERR</td><td>106</td><td>If user doesn’t have permission to access specified content.
 *         Eg. DRM file or files inside private folders.</td></tr>
 * <tr><td>SIZE_EXCEEDED_ERR</td><td>107</td><td>Data exceeded allowed limits set by a platform 
 *         or by a configuration. Typically data overflow error.</td></tr>
 * <tr><td>INVALID_URI_ERR</td><td>108</td><td>Specified uri is invalid. i.e. doesn’t conform to uri schema</td></tr>
 * <tr><td>URI_NOT_FOUND_ERR</td><td>109</td><td>Specified uri refers to non existing resource.</td></tr>
 * <tr><td>URI_ALREADY_EXISTS_ERR</td><td>110</td><td>Specified uri refers to existing resource. 
 *         Typically this error code used to protect destination resource not been overwritten.</td></tr>
 * <tr><td>URI_ALREADY_EXISTS_ERR</td><td>111</td><td>Specified uri refers to existing resource. 
 *         In case device runs out of mememory while performing the operation.</td></tr>
 * </table> 
 * @param {number} code A code number for the cause of the exception.
 * @param {string} message A free-form message explaining why this exception is thrown.
 * @return DeviceAPIError 
 */
nokia.device.DeviceAPIError = function (code,message)    {
        /**
        * The name of the Error, will always be DeviceAPIError
        */
        this.name    = 'DeviceAPIError';
        /**
        * A message describing the error in a human-readable way.
        */
        this.message = message;
        /**
         * Exception cause as a code number. Values in the range 1-99 indicate
         * non-recoverable errors, and values >= 100 indicate recoverable errors.
         */
        this.code    = code;
        this.MISSING_ARG_ERR            = 1;
        this.INVALID_ARG_ERR            = 2;
        this.NOT_SUPPORTED_ERR          = 3;
        this.TIMEOUT_ERR                = 100;
        this.DATA_NOT_FOUND_ERR         = 101;
        this.DATA_ALREADY_EXISTS_ERR    = 102;
        this.SERVICE_BUSY_ERR           = 103;
        this.SERVICE_IN_USE_ERR         = 104;
        this.DATA_OUT_OF_RANGE_ERR      = 105;
        this.NOT_ALLOWED_ERR            = 106;
        this.SIZE_EXCEEDED_ERR          = 107;
        this.INVALID_URI_ERR            = 108;
        this.URI_NOT_FOUND_ERR          = 109;
        this.URI_ALREADY_EXISTS_ERR     = 110;
        this.NO_MEMORY_ERR              = 111;
        this.DIR_NOT_EMPTY_ERR          = 500;
        this.FILE_ALREADY_OPEN_ERR      = 501;
        this.URI_NOT_SUPPORTED          = 502;              
    };

nokia.device.DeviceAPIError.prototype = new Error();

    
nokia.device.DeviceAPIError.prototype.toString = function(){
    return(this.name + " : " + this.code + " : " + this.message);
};
		
var asyncCallbackMap = {
	usec_count:0,
	callbackArray: new Array(),
	getTransactionId: function(){
		var KHrs=24,KMin=60,KSec=60,KMcSec=1000;
		var currentTime = new Date();
		this.usec_count++;
		/*return   ((KMcSec * KHrs * KMin * KSec * currentTime.getDate())+
		(KMcSec * KMin * KSec * currentTime.getHours())+ 
		(KMcSec * KSec * currentTime.getMinutes())+
		(KMcSec * currentTime.getSeconds()) +*/
		return this.usec_count;
	},
	add: function(sCb, errCb,options){
		var obj = new Object();
        obj.success_cb = sCb;
		obj.error_cb = errCb;
		obj.options = options;
        obj.transactionId = this.getTransactionId();        
        this.callbackArray.push(obj);
		return obj.transactionId;
	},
	get: function(tid){
		var i = this.callbackArray.length -1;
        for (; i >= 0; i--) {
            if (this.callbackArray[i].transactionId == tid) {
                return this.callbackArray[i];
            }
        }
        return null;
	},
	remove: function(tid){
		var i = this.callbackArray.length -1;
        for (; i >= 0; i--) {
            if (this.callbackArray[i].transactionId == tid) {
                this.callbackArray.splice(i, 1);
            }
        }
	}
	
};
