#
# ============================================================================
#  Name        : serviceipc.pro
#  Part of     : Service Framework / IPC
#  Description : Service Framework IPC
#  Version     : %version: 17 %
#
# Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
#
# This file is part of Qt Web Runtime.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public License
# version 2.1 as published by the Free Software Foundation.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
TEMPLATE = lib
TARGET = WrtServiceIpcClient
QT -=gui
CONFIG += link_prl create_prl

ROOT_DIR = $$PWD/../../..
WRT_DIR = $$ROOT_DIR/wrt

include($$WRT_DIR/cwrt.pri)

#Sources
HEADERS += serviceipcdefs.h \
           serviceipc_p.h \
           serviceipc.h \ 
           serviceipcfactory.h \
           serviceipcsharedmem_p.h \
           serviceipcclient.h
SOURCES += serviceipc.cpp \ 
           serviceipcfactory.cpp \
           serviceipcsharedmem.cpp \
           serviceipcclient.cpp

DEFINES += QT_MAKE_IPC_DLL
INCLUDEPATH += $$CWRT_INCLUDE 


EXPORT_FILES = serviceipcdefs.h serviceipc.h serviceipcclient.h

QT +=network
HEADERS += ./platform/qt/serviceipclocalsocket_p.h
SOURCES += ./platform/qt/serviceipclocalsocket.cpp
INCLUDEPATH += $$PWD/platform/qt
    
EXPORT_DIR = $$CWRT_INCLUDE

include($$WRT_DIR/cwrt-export.pri)

headers.files = $$EXPORT_FILES
headers.path = $$CWRT_INSTALL_INC_DIR/wrt/ipc/serviceipc

INSTALLS += headers
