# Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
#
# This file is part of Qt Web Runtime.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public License
# version 2.1 as published by the Free Software Foundation.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
#

isEmpty(_CWRT_MAEMO_PRI_INCLUDED_): {
    _CWRT_MAEMO_PRI_INCLUDED_=1

    maemo5 {
        cwrt-services {
            what += widgets services providers
        } else {
            what += widgets services
        }
        DEFINES += Q_OS_MAEMO5
    }

    DEFINES += __MAEMO__

    #
    # Target compilation target (i386/armel)
    # Used for distinguish armel and i386 compilations, meaning
    # that object files are stored into target architecture specific folders.
    #
    TARGET_ARCH_TMP=$$system(dpkg-architecture)
    contains(TARGET_ARCH_TMP, DEB_HOST_ARCH=armel) {
        TARGET_ARCH=armel
        DEFINES += __ARMEL__
        # Armel needed some specific code
    }

    contains(TARGET_ARCH_TMP, DEB_HOST_ARCH=i386) {
        TARGET_ARCH=i386
    }

    isEmpty( TARGET_ARCH ) {
         TARGET_ARCH=platform
    }

    CONFIG+=maemo-$$TARGET_ARCH

    OBJECTS_DIR = $$OBJECTS_DIR/$$TARGET_ARCH
    MOC_DIR = $$MOC_DIR/$$TARGET_ARCH
    RCC_DIR = $$RCC_DIR/$$TARGET_ARCH
    UI_DIR =  $$UI_DIR/$$TARGET_ARCH
    TEMPDIR = $$TEMPDIR/$$TARGET_ARCH
    DESTDIR = $$DESTDIR/$$TARGET_ARCH

    QMAKE_RPATHDIR = $$CWRT_INSTALL_LIB_DIR $$DESTDIR $$QMAKE_RPATHDIR
    CONFIG(maemo-armel) {
        message( "build arch is armel" )
        QMAKE_RPATHDIR += $$INSTALL_PREFIX/lib
    }
    LIBS += -L$$DESTDIR

    # List of JS APIs added to maemo build
    DEFINES += JS_MENU
    DEFINES += JS_MENUITEM
    DEFINES += JS_CONTEXT_MENU
    DEFINES += JS_WIDGET_INTERFACE
    DEFINES += JS_ONLOAD

    QT += webkit

    message( "Building $$TARGET for maemo target to $$TARGET_ARCH" )
}
