/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef _WRTINSPECTOR_H_INCLUDED_
#define _WRTINSPECTOR_H_INCLUDED_

#include <QGraphicsProxyWidget>

class QGraphicsItem;
class QWebPage;
class QWebInspector;


namespace WRT {
   namespace Maemo {

      class WrtWebInspector : public QGraphicsProxyWidget {
         public:
            explicit WrtWebInspector( QGraphicsItem * parent = 0);
            virtual ~WrtWebInspector();
            void setPage( QWebPage* page);

         private:
            QWebInspector* m_inspector;
      };

   } // namespace Maemo
} // namespace WRT

#endif // _WRTINSPECTOR_H_INCLUDED_

