/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef WEBWIDGETRUNNER_H
#define WEBWIDGETRUNNER_H

#include <QFileInfo>
#include <QObject>
#include <QRect>
#include <QSize>
#include <QPointer>

class QMenu;
class WidgetProperties;

namespace WRT {

class WrtPage;
class WidgetContainerMaemo;

namespace Maemo {

class WebWidget;
class HomeScreenView;
class StandaloneView;

class WebWidgetRunner : public QObject
{
    Q_OBJECT

public:
    enum WidgetViewMode {
        MinimizedViewMode,
        FloatingViewMode,
        FullscreenViewMode,
        WindowedViewMode,
        WidgetViewModeCount
    };

    WebWidgetRunner();
    virtual ~WebWidgetRunner();

    bool load(QString desktopFilePath);
    WidgetViewMode viewMode() const;
    void setInitialSize(const QSize&);
    QSize initialSize() const;
    QSize fallbackSize() const;

private slots:
    void onHomeViewClicked();
    void onFrameTitleChanged(const QString& title);
    void onFrameLoadFinished(bool ok);
    void onViewModeChangeRequested(QString viewMode);
    void onVisibilityChanged(bool visible);
    void onStandaloneViewActivated();
    void onStandaloneViewExitRequested();

private:
    void loadWidgetView();

    QString homeScreenId() const;
    bool prepareHomeScreenView(const QSize&, bool deleteStandaloneView = true);
    void prepareStandaloneView();
    bool setViewMode(WidgetViewMode mode, bool deleteCurrentView = true);
    void createViewMenu();
    WidgetViewMode preferredStandaloneViewMode();
    bool initInspector(WidgetProperties* widgetProps);

    WrtPage* m_page;
    QPointer<HomeScreenView> m_homeScreenView;
    QPointer<StandaloneView> m_standaloneView;
    QMenu* m_menu;

    WebWidget* m_webWidget;
    WidgetContainerMaemo* m_widgetContainer;

    QSize m_initialSize;
    QSize m_fallbackSize;
    QRect m_lastGeometry;
    WidgetViewMode m_viewMode;
    WidgetViewMode m_lastHomeScreenViewMode;
    WidgetViewMode m_lastStandaloneViewMode;

    QFileInfo m_desktopFileInfo;

    bool m_webInspector;
};

}
}

#endif // WEBWIDGETRUNNER_H
