/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef VIEWMODE_H
#define VIEWMODE_H

#include "webwidgetrunner.h"

namespace WRT {
namespace Maemo {

struct ViewModeInfo
{
    WebWidgetRunner::WidgetViewMode mode;
    const char* name;
};

static ViewModeInfo viewModeMap[WebWidgetRunner::WidgetViewModeCount] = {
    { WebWidgetRunner::MinimizedViewMode, "minimized" },
    { WebWidgetRunner::FloatingViewMode, "floating"},
    { WebWidgetRunner::FullscreenViewMode, "fullscreen" },
    { WebWidgetRunner::WindowedViewMode, "windowed" }
};

static inline bool getViewModeValue(QString name, WebWidgetRunner::WidgetViewMode& mode)
{
    name = name.toLower();
    for (int i = 0; i < WebWidgetRunner::WidgetViewModeCount; ++i)
        if (viewModeMap[i].name == name) {
            mode = viewModeMap[i].mode;
            return true;
        }
    return false;
}

static inline QString getViewModeName(WebWidgetRunner::WidgetViewMode mode)
{
    for (int i = 0; i < WebWidgetRunner::WidgetViewModeCount; ++i)
        if (viewModeMap[i].mode == mode)
            return viewModeMap[i].name;
    return QString();
}

}
}

#endif
