/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#include "miniview.h"

#include "wrtpage.h"

#include <QPaintEvent>
#include <QPainter>
#include <QPixmap>
#include <QWebFrame>
#include <QX11Info>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

namespace WRT {
namespace Maemo {

MiniView::MiniView(const QString& id, QWidget* parent)
    : HomeScreenView(id, parent)
{
    // Set the widget not to receive the input focus. It avoids the need
    // to receive focus before receiving mouse input events.
    XWMHints wmhints;
    wmhints.flags = InputHint;
    wmhints.input = False;
    XSetWMHints(QX11Info::display(), winId(), &wmhints);
}

MiniView::~MiniView()
{
}

void MiniView::mouseReleaseEvent(QMouseEvent* event)
{
    emit clicked();
    HomeScreenView::mouseReleaseEvent(event);
}

void MiniView::setPage(WrtPage* page)
{
    connect(page, SIGNAL(repaintRequested(QRect)),
            this, SLOT(onRepaintRequested(QRect)));

    HomeScreenView::setPage(page);
}

void MiniView::paintEvent(QPaintEvent* event)
{
    HomeScreenView::paintEvent(event);

    if (!m_page)
        return;

    QPainter painter(this);
    m_page->mainFrame()->render(&painter, event->region());
}

void MiniView::onRepaintRequested(const QRect& dirtyRect)
{
    // FIXME: We should paint this dirtyRect imediatelly. However,
    // repaint() is causing eventual recursive repaints, so i'm
    // placing a temporary update(), which may cause painting
    // to be postponed until next idle.
    update(dirtyRect);
}

}
}
