/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifndef EXITBUTTON_H
#define EXITBUTTON_H

#include <QToolButton>
#include <QEvent>

namespace WRT {
namespace Maemo {

class ExitButton : public QToolButton
{
    Q_OBJECT

public:
    inline explicit ExitButton(QWidget *parent);

protected:
    inline bool eventFilter(QObject *obj, QEvent *event);
};


ExitButton::ExitButton(QWidget *parent)
    : QToolButton(parent)
{
    Q_ASSERT(parent);

    setFixedSize(sizeHint());
    setAutoFillBackground(true);

    QPalette pal = palette();
    QColor backgroundColor = pal.color(backgroundRole());
    backgroundColor.setAlpha(128);
    pal.setColor(backgroundRole(), backgroundColor);
    setPalette(pal);

    parent->installEventFilter(this);
}

bool ExitButton::eventFilter(QObject *obj, QEvent *event)
{
    if (obj != parent())
        return QToolButton::eventFilter(obj, event);

    QWidget *parent = parentWidget();
    bool isFullScreen = parent->windowState() & Qt::WindowFullScreen;

    switch (event->type()) {
    case QEvent::WindowStateChange:
        setVisible(isFullScreen);
        if (isFullScreen)
            raise();
    case QEvent::Resize:
        if (isVisible())
            move(parent->width() - width(),
                 parent->height() - height());
        break;
    default:
        break;
    }

    return QToolButton::eventFilter(obj, event);
}

}
}

#endif
