/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef _WGZ_WIDGET_H_
#define _WGZ_WIDGET_H_

#include "SuperWidget.h"

/*****************************************************************************
 * Wgz specific widget
 *
 * *************************************************************************/
class WgzWidget: public SuperWidget {
public:
    WgzWidget(QString& rootDirectory);
    virtual ~WgzWidget() {};

    virtual WidgetInstallError install(const bool update=false);
    virtual WidgetProperties* getProperties(const QString& pkgPath=""){return SuperWidget::getProperties(pkgPath);};
    virtual QString launcherPath(const QString &pkgPath);

    SuperWidget* toWgt();
    virtual void writeManifest(const QString& path="");
    virtual QString value(const QString& key, const QString & attribute = QString(""));

    /**
     * Returns true if the key with the attribute exists in widget metadata; otherwise false.
     * @param key a key in plist metadata
     * @attribute the attribute is an optional argument. With attribute you can test whether a value
     * of given attribute within specified key exists in plist metadata.
     */
    bool contains( const QString & key, const QString & attribute = QString(""));

    virtual bool unZipBundle(const QString& path){return SuperWidget::unZipBundle(path);};
    virtual bool parseManifest(const QString& path="", const bool force=false);


protected:
    virtual void initialize(QString& rootDirectory) {SuperWidget::initialize(rootDirectory);};
    virtual WidgetProperties* widgetProperties();
    virtual bool findStartFile(QString& startFile,const QString& path="");
    virtual bool findIcons(QStringList& icons, const QString& path="");
    virtual bool findFeatures(WidgetFeatures& features, const QString& widgetPath="");

    virtual bool setWidgetRootPath(const QString& path="");
};
#endif
