/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef _CONFW3XMLPARSER_H
#define _CONFW3XMLPARSER_H

#include <QXmlStreamReader>

class W3CElement;
class QStringList;
class QXmlStreamReader;

typedef QMap<QString , W3CElement *> ConfigContainer;
typedef QMap<QString , QVariant> WidgetAttributesMap;
#define XMLNS_STRING "http://www.w3.org/ns/widgets"
#define XMLNS_JIL_STRING "http://www.jil.org/ns/widgets"

class  ConfigXmlParser
{
public:
    ConfigXmlParser(const QString &confFile = QString());
    ~ConfigXmlParser();
    void setFile(const QString &afile) { m_file = afile; }
    bool parseFile();
    QString namespaceUri() { return m_namespace; }
    QString id() { return m_id; }
    QString version() { return m_version; }
    QString language() const { return m_lang; }
    QString height() const { return m_height; }
    QString width() const { return m_width; }
    QString viewmodes() const { return m_viewmodes; }
    QStringList allKeys();
    bool contains(const QString &aKey , QString *aLang = NULL) const;
    int count() const { return m_container.count(); }
    int count(const QString &aKey , QString *lang = NULL) const;

    /**
     * Owner ship is not transfred for returned address
     * ConfigXML parser owns all the returned objects
     **/
    const W3CElement *getElement(const QString &aKey, const QString &aLang=QString("") ) const;
    const W3CElement *getElement(const QString &aKey, int pos, const QString &aLang= QString("")) const;

private:
    ConfigXmlParser(const ConfigXmlParser &aParser);
    ConfigXmlParser & operator=(const ConfigXmlParser &aParser);

    // internal utility functions
    bool parseWidgetAccessElement();
    bool parseFeatureElement();
    bool parseParamElement();
    bool parsePreference();
    bool parseAuthorElement();
    bool parseIconElement();
    bool parseServerElement();
    bool parseDeltaElement();
    bool parseNameElement();
    bool parseDescriptionElement();
    bool parseLicenseElement();
    bool parseContentElement();
    bool parseSharedLibraryElement();
    bool isLocalizable(const QString &aString) const;

private:
    QString m_lang;
    QString m_version;
    QString m_id;
    QString m_namespace ;
    QString m_file ;
    QString m_height;
    QString m_width;
    QString m_viewmodes;
    QString m_services;
    QXmlStreamReader m_xmlreader;
    ConfigContainer m_container;
    bool m_isFeatureTagPrevElement;
    bool m_isSharedLibraryTagPrevElement;
    bool m_isAllUrls;
    bool m_isFirstJilAccessTag;

private:
    //occurence counts
    int m_accessCount;
    int m_featureCount;
    int m_paramCount;
    int m_paramTotalCount;
    int m_preferenceCount;
    int m_iconCount;
};

#endif
