/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */


#include <QDir>
#include <QMapIterator>
#include <QDebug>

#include "wrtpage.h"
#include "qwebframe.h"

#include "wrtapiinterface.h"
#include "wrtapiconf.h"
#include "jsmenuitemfactory.h"
#include "jsviewmenu.h"
#include "jscontextmenu.h"
#include "jswidgetinterface.h"
#include "jsresourcewrapper.h"
#include "jsversion.h"

#include "serviceloader.h"
#include "wrtapiprovider.h"

namespace WRT {



WrtApiProviderPrivate::WrtApiProviderPrivate() {
    m_serviceLoader = 0;
}


WrtApiProviderPrivate::~WrtApiProviderPrivate() {
}


WrtApiProvider::WrtApiProvider() {
    d = new WrtApiProviderPrivate();
}


WrtApiProvider::~WrtApiProvider() {
    destroyInstance(d->m_serviceLoader);
    delete d;
}


void WrtApiProvider::setApis(QStringList apis) {
    d->m_apiNames = apis;
}


void WrtApiProvider::handleNewInstance(WRT::ServiceLoader* loader) {
    d->m_serviceLoader = loader;
    WrtApiInterface* api;
    QObject* apiObject;

    foreach(QString apiName, d->m_apiNames) {

        // This could be replaced with plugin system if needed

        api = 0;
        apiObject = 0;

        if (apiName == MenuItem) {
            JSMenuItemFactory* menuItemFactory = new JSMenuItemFactory();
            api = menuItemFactory;
            apiObject = menuItemFactory;
        }
        else if (apiName == Menu) {
            JSViewMenu* menu = new JSViewMenu();
            api = menu;
            apiObject = menu;
        }
        else if (apiName == ContextMenu) {
            JSContextMenu* contextMenu = new JSContextMenu();
            api = contextMenu;
            apiObject = contextMenu;
        }

        else if (apiName == WidgetInterface) {
            JSWidgetInterface * widgetInterface = new JSWidgetInterface();
            api = widgetInterface;
            apiObject = widgetInterface;
        }

        else if (apiName == Version) {
            JSVersion * version = new JSVersion();
            api = version;
            apiObject = version;
        }

        else if (apiName.endsWith(".js")) {
            JSResourceWrapper * jsResource = new JSResourceWrapper(apiName, "");
            api = jsResource;
            apiObject = jsResource;
        }

        if (api) {
            api->setWebPage(d->m_serviceLoader->getContext());
            if (!api->name().isEmpty()) {
                // TODO : QScriptEngine ownership must be added.
                d->m_serviceLoader->addService(api->name(), *apiObject);
            }
            d->m_apis.insert(apiName, api);
        }
    }
}


void WrtApiProvider::destroyInstance(WRT::ServiceLoader* loader) {
    Q_UNUSED(loader);
}

void WrtApiProvider::pageOnReload() {
    WrtApiInterface* api;
    foreach(QString apiName, d->m_apiNames) {
        api = d->m_apis.value(apiName, 0);
        if (api) {
            api->pageOnReload();
        }
    }
}

WrtApiInterface* WrtApiProvider::apiObject(QString name) {
    return d->m_apis.value(name, 0);
}

}
