/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */


#ifndef JSWIDGETINTERFACE_H_
#define JSWIDGETINTERFACE_H_

#include "jsresourcewrapper.h"
#include <QStringList>

namespace WRT {
class JSWidgetInterface : public JSResourceWrapper{
    Q_OBJECT
public:
    explicit JSWidgetInterface();
    virtual ~JSWidgetInterface();

    /**
     * Inherited from JSResoruceWrapper. This function is invoked before JavaScript
     * resource file is evaluated into window object.
     *
     * Evaluates the current user agent language into window object.
     */
    virtual void beforeJavaScriptEvaluation();

    virtual void pageOnReload();

    void setCommandline(QString param);
    void setMessage(QString param);

    void onShow();
    void onHide();

    void onViewModeChange(QString viewMode);

public Q_SLOTS:
    void openUrl(QString iri);

    void setViewMode(QString viewMode);
    QString viewMode() const;

signals:
    void viewModeChangeRequested(QString viewMode);
    void viewModeChanged(QString viewMode);

private Q_SLOTS:
    void loadFinished();

private:
#ifdef WIDGET_EXTENSION
    QString m_commandline;
    QString m_message;
#endif

    QString m_viewMode;
    bool m_visible;
    bool m_delayedVisibilityNotification;
};

}
#endif /* JSWIDGETINTERFACE_H_ */
