/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */


#ifndef __WEBJSMENUITEM_H
#define __WEBJSMENUITEM_H

#include "jsresourcewrapper.h"

namespace WRT {

class Action;

class JSMenuItem : public JSResourceWrapper
{
    Q_OBJECT
    Q_PROPERTY(QString name WRITE setText)
    Q_PROPERTY(bool disabled WRITE setDisabled)

public:

    explicit JSMenuItem(QString exposeName);
    virtual ~JSMenuItem();

    void setText(QString name);
    void setDisabled(bool disabled);
    Action* action();

public slots:
    void addToJavaScriptWindowObject();
    bool addMenuItem(int nativeInstanceHandle);
    bool removeMenuItem(int nativeInstanceHandle);
    bool insertMenuItem(int nativeInstanceHandle, int beforeIndex);

private:
    Action* m_action;

};

}

#endif
