/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */


#ifndef __JSMENU_H
#define __JSMENU_H

#include <QObject>
#include <QString>
#include <qwebpage.h>

#include "jsresourcewrapper.h"

class QWidget;
class QGraphicsWidget;

class JSMenuTest;
class JSContextMenuTest;

namespace WRT {

class Action;
class ActionAdapter;

class JSMenu : public JSResourceWrapper
{
    Q_OBJECT

    public:

        explicit JSMenu(QString jsResource, QString jsObjectName);
        virtual ~JSMenu();
        void setMenuWidget(QWidget* widget);
        void setMenuWidget(QGraphicsWidget* widget);

    private slots:
        void menuCallback(int itemId);

    protected:
        ActionAdapter* m_actionAdapter;
        QString m_currentHTMLElementId;

        friend class ::JSContextMenuTest;
        friend class ::JSMenuTest;

};
}

#endif
