/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#include <QSignalMapper>
#include <QWidget>
#include <QGraphicsWidget>
#include <qwebframe.h>
#include "action.h"
#include "actionadapter.h"
#include "jsmenu.h"

namespace WRT {

/*!
    \class WRT::JSMenu
    \brief The WRT::JSMenu

    \inmodule WidgetCore

    WRT::JSMenu base class for WRT menus. This class is responsible for calling callback function of JavaScript menu item
    when native menu action gets triggered.
*/

/*!
    Constructs an instance of WRT::JSMenu that evaluates contextmenu.js resource into current frame.
*/
JSMenu::JSMenu(QString jsResource, QString jsObjectName)
    : JSResourceWrapper(jsResource, jsObjectName)
    , m_actionAdapter(0)
    , m_currentHTMLElementId("undefined")
{
}

JSMenu::~JSMenu()
{
    if (m_actionAdapter) {
        m_actionAdapter->disconnect();
        delete m_actionAdapter;
    }
}

/*!
    Sets menu \a widget that is used as widget where to collect menu items.
*/
void JSMenu::setMenuWidget(QWidget* widget) {
    if (widget) {
        if (m_actionAdapter) {
            m_actionAdapter->disconnect();
            delete m_actionAdapter;
        }

        m_actionAdapter = new ActionAdapter(widget);
        connect(m_actionAdapter->signalMapper(), SIGNAL(mapped(int)),
                this, SLOT(menuCallback(int)));
    }
}

/*!
    Sets menu \a widget that is used as widget where to collect menu items.
    \overload setMenuWidget()
*/
void JSMenu::setMenuWidget(QGraphicsWidget* widget) {
    if (widget) {
        if (m_actionAdapter) {
            m_actionAdapter->disconnect();
            delete m_actionAdapter;
        }

        m_actionAdapter = new ActionAdapter(widget);
        connect(m_actionAdapter->signalMapper(), SIGNAL(mapped(int)),
                this, SLOT(menuCallback(int)));
    }
}

/*!
 *    Helper method for firing onselect callback of a menu item.
 */
void JSMenu::menuCallback(int itemId) {
    QString script = "";
    if (m_currentHTMLElementId != "undefined") {
        script = QString("if ('function' === typeof menuItemFactoryCPP.mapping[%1].onselect) { menuItemFactoryCPP.mapping[%1].onselect('%2'); }").arg(itemId).arg(m_currentHTMLElementId);
    } else {
        script = QString("if ('function' === typeof menuItemFactoryCPP.mapping[%1].onselect) { menuItemFactoryCPP.mapping[%1].onselect(); }").arg(itemId);
    }
    JSResourceWrapper::webPage()->currentFrame()->evaluateJavaScript(script);

}

}
