/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
widget = (function() {

    var configXml;
    var names;
    var authors;
    var descriptions;
    var widgetAttrs;
    var viewMode;

    var attributes = {
        "openURL": function(url) { widgetInterfaceCPP.openUrl(url); },
    };

    attributes.__defineSetter__("viewMode", function(mode) {
        widgetInterfaceCPP.setViewMode(mode);
    });

    attributes.__defineGetter__("viewMode", function() {
        return widgetInterfaceCPP.viewMode();
    });

    attributes.__defineSetter__("width", function(mode) {
    });

    attributes.__defineGetter__("width", function() {
        return window.innerWidth;
    });

    attributes.__defineSetter__("height", function(mode) {
    });

    attributes.__defineGetter__("height", function() {
        return window.innerHeight;
    });

    var widgetElementLang = "";

    /**
     * Set readonly field to attribute object.
     * @param fieldName name of the field that is added to attribute object
     * @param object the object where the getter reads the attribute value.
     * @param fieldValueGetter when fieldValueGetter is not null that is used to read the getter value.
     * @param isNumeric true if attribute needs to be converted to number, otherwise false.  
     */
    function setReadOnly(fieldName, object, fieldValueGetter, isNumeric) {
        attributes.__defineSetter__( fieldName, function() {
        } );
        
        attributes.__defineGetter__( fieldName, function() {
            var value = null;
            if (object !== undefined && fieldValueGetter != null) {
                value = object[fieldValueGetter];
            } else if (object !== undefined) {
                value = object;
            } else {
                // null
                return value;
            }
            
            return (isNumeric) ? +value : value;
        } );
        
    
    }
    
    /**
     * Initialize W3C Widget Interface preferences attribute.
     * This reads preference elements from config.xml and sets them into localStorage.
     * Read only attributes are not handled.
     */
    function initPreferences() {
        
        var prefs = configXml.getElementsByTagName("preference");
        var i = 0;
        
        for (i; i < prefs.length; ++i) {
            var pair = prefs[i].attributes;
            var name = pair["name"].value;
            var value = pair["value"] !== undefined ? pair["value"].value : null;
            
            if (localStorage.getItem(name) == null) {
                localStorage.setItem(name, value);
            }
        }
        setReadOnly("preferences", localStorage, null, false);
    }
    
    /**
     * Parse config.xml
     */
    function parse(){
        var xmlhttp = new XMLHttpRequest();
        try{
            xmlhttp.open("GET", "config.xml", false);
        }catch(e){
            return;
        }
        try {
            xmlhttp.send("");    
        } catch (e) {
            return;
        }
        
        configXml = xmlhttp.responseXML;
        names = configXml.getElementsByTagName("name");
        authors = configXml.getElementsByTagName("author");
        descriptions = configXml.getElementsByTagName("description");
        widgetAttrs = configXml.getElementsByTagName("widget")[0].attributes;
        
        if (widgetAttrs["xml:lang"] !== undefined) {
            widgetElementLang = widgetAttrs["xml:lang"].value;
        }
        
    }
    
    /**
     * Find localized element based on give language.
     * Only name and description elements are localized into W3C Widget Interface
     */
    function findLocalizedElement(elements, lang) {
        var attnode = null;
        if (lang.length > 0) {
            var langArray = lang.split("-");
            var currentLang = "";
            var notLocalizedElement = null;
            while (langArray.length > 0) {
                currentLang = langArray.join("-");
                var i = 0;                
                for (i; i < elements.length; ++i) {
                    attnode=elements(i).getAttributeNode("xml:lang");
                    if (attnode != null && attnode.value == currentLang) {
                        return elements[i];
                    } else if (attnode == null) {
                        notLocalizedElement = elements[i];
                    } 
                }
                // Remove last
                langArray.pop();
            }
            
            // Return either the not localized or first
            return (notLocalizedElement != null) ? notLocalizedElement : elements[0]; 
        } else {
            return elements[0];
        } 
       
    }
    
    /**
     * Initilizes Widget Interface attrbutes to readonly mode.
     * When attribute is not in present, null value is set to the field.
     */
    function initWidgetInterface(lang) {
        // Author object
        if (authors.length > 0) {
            setReadOnly("author", authors[0], "textContent", false);
            setReadOnly("authorHref", authors[0].attributes["href"], "value", false);
            setReadOnly("authorEmail", authors[0].attributes["email"], "value", false);
        } else {
            setReadOnly("author", undefined, "textContent", false);
            setReadOnly("authorHref", undefined, "value", false);
            setReadOnly("authorEmail", undefined, "value", false);
        }
        
        // Description
        if (descriptions.length > 0) {
            var desc = findLocalizedElement(descriptions, lang);
            setReadOnly("description", desc, "textContent", false);
        } else {
            setReadOnly("description", undefined, "textContent", false);
        }
        
        // Name
        if (names.length > 0) {
            var name = findLocalizedElement(names, lang);
            setReadOnly("name", name, "textContent", false);
            setReadOnly("shortName", name.attributes["short"], "value", false);
        } else {
            setReadOnly("name", undefined, "textContent", false);
            setReadOnly("shortName", undefined, "value", false);
        }
        
        // Widget object
        setReadOnly("id", widgetAttrs["id"], "value", false);
        setReadOnly("version", widgetAttrs["version"], "value", false);

        // Preferences
        initPreferences();

    }

    parse();
    initWidgetInterface(__uaLang);
    return attributes;

})()
