/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef _wgtjswidget_h
#define _wgtjswidget_h

#include <QObject>
#include <QVariant>
#include "w3cjswidget.h"

namespace WRT {

class WrtWidgetPage;
class WidgetContainer;

class WgtJSWidget : public W3CJSWidget {

    Q_OBJECT

public:
    void notificationRecieved(WidgetContainer::WrtWidgetNotify value);

    WgtJSWidget(WidgetContainer *);
    ~WgtJSWidget();

public slots:
    QVariant preferenceForKey(const QVariant& key);
    void setPreferenceForKey(const QVariant& value, const QVariant& key);
    void prepareForTransition(const QString& mode);
    void performTransition();
    void setNavigationEnabled(bool flag);
    void setNavigationType(QString type);
    void openApplication(QString uid);
    QString identifier() const;

private:
    WidgetContainer* m_wrtWidgetContainer;
};

}
#endif
