/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#include "superjswrt.h"
#include "wrtwidgetcontainer.h"

#include <QDebug>

#if defined(Q_OS_SYMBIAN)
#include "s60/s60platform.h"
#endif

using namespace WRT;

SuperJSPlatform::SuperJSPlatform()
{
#if defined(Q_OS_SYMBIAN)
    m_platformInstance = new S60Platform();
#elif defined(Q_OS_WIN32)
    m_platformInstance = new Win32Platform();
#elif defined(Q_OS_LINUX)
    m_platformInstance = new LinuxPlatform();
#else
    m_platformInstance = new Platform();
#endif
}

SuperJSPlatform::~SuperJSPlatform(){
    delete m_platformInstance;
}

SuperJSWrt::SuperJSWrt(WidgetContainer* wrtWidgetContainer)
:m_wrtWidgetContainer(wrtWidgetContainer)
{
    m_platform = new SuperJSPlatform();
}

SuperJSWrt::~SuperJSWrt()
{
    delete m_platform;
}

PlatformPrivate::PlatformPrivate(): m_id(NOTAVAILABLE),
m_romVersion(NOTAVAILABLE), m_packageVersion(NOTAVAILABLE),
m_manufacturer(NOTAVAILABLE), m_model(NOTAVAILABLE),
m_reversion(NOTAVAILABLE)
{
}

