/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */


#ifndef __SUPERJSWIDGET_H
#define __SUPERJSWIDGET_H

//  INCLUDES
#include <QObject>
#include <QString>
#include <QVariant>
#include "wrtwidgetcontainer.h"
#include "wrtpage.h"
#include "qwebframe.h"

// FUNCTION PROTOTYPES

namespace WRT {

    // FORWARD DECLARATION
    class JSWrt;
    class WidgetContainer;

    // CLASS DECLARATION
    class SuperJSWidgetPrivate
    {
    public:
        SuperJSWidgetPrivate(WidgetContainer* wrtWidgetContainer);
        virtual ~SuperJSWidgetPrivate();

    public:
        WidgetContainer* m_wrtWidgetContainer;
        QObject* m_wrt;
    };


    /**
    *  SuperJSWidget
    *
    */
    class SuperJSWidget : public QObject
    {
        Q_OBJECT
        Q_PROPERTY(QObject* wrt READ jsWrt)

    public:
        SuperJSWidget(WidgetContainer* wrtWidgetContainer);
        ~SuperJSWidget();

        QString identifier() const;
        QObject* jsWrt() const;
        WidgetContainer* widgetContainer() const {return d->m_wrtWidgetContainer;}

        virtual void notificationRecieved(WidgetContainer::WrtWidgetNotify value);

    public:
        QVariant preferenceForKey(const QVariant& key);
        void setPreferenceForKey(const QVariant& value, const QVariant& key);

    public slots:
        void openURL(QString url);


    private:
        SuperJSWidgetPrivate*                 d;

    };

}

#endif
