/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef _jiljswidget_h
#define _jiljswidget_h

#include <QObject>
#include <QVariant>
#include "w3cjswidget.h"

namespace WRT {

class WrtWidgetPage;
class WidgetContainer;

class JILJSWidget : public W3CJSWidget {

    Q_OBJECT

public:
    void notificationRecieved(WidgetContainer::WrtWidgetNotify value);

    JILJSWidget(WidgetContainer *);
    ~JILJSWidget();

public slots:
    QVariant preferenceForKey(const QVariant& key);
    void setPreferenceForKey(const QVariant& value, const QVariant& key);

private:
    WidgetContainer* m_wrtWidgetContainer;
};

}
#endif
