/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#include <QFile>
#include <QProcess>
#include <QNetworkProxy>
#include "qwebsettings.h"
#include "qwebframe.h"
#include "wrtsettings.h"
#include "wrtpage.h"
#include "wrtnetworkaccessmanager.h"

// Uri scheme handler
#include "SchemeHandler.h"

// Plugins
#include "serviceprovider.h"
#include "serviceloader.h"
#include "pluginserviceprovider.h"
#include "applicationlauncher.h"

#include "wrtwidgetcontainerMaemo.h"

#include "customschemehandler.h"

#include "WebAppRegistry.h"
#include "WidgetProperties.h"

namespace WRT {

   WidgetContainerMaemo::WidgetContainerMaemo() : WidgetContainerBase(0, WRT::GraphicsWebView),
   m_serviceProvider(0),m_serviceLoader(0),m_launcher(0),m_schemeHandler(0){

      //FIXME
      //This is for temporay fixing the network. For Maemo there is currently now connection establishemt
      //since we are 'allways' online. This is going to change probaly. --Lörre
      emit connectionEstablished();

      // TODO: find a proper place for this
#ifdef Q_OS_MAEMO5
      qDebug() << "Creating custom scheme handler";
      WRT::Maemo::CustomSchemeHandler* cs = new WRT::Maemo::CustomSchemeHandler(this);

      // make WebKit delegate all external links to someone else
      wrtPage()->setLinkDelegationPolicy(QWebPage::DelegateExternalLinks);

      // connect the actual delegate function and WebKit together
      connect(wrtPage(), SIGNAL(linkClicked(QUrl)), cs, SLOT(slotLinkClicked(QUrl)));

#endif
  }

  WidgetContainerMaemo::~WidgetContainerMaemo() {
      delete m_serviceProvider;
      delete m_serviceLoader;
      delete m_schemeHandler;
  }

#ifdef Q_OS_MAEMO6
  void WidgetContainerMaemo::loadPlugins(
      QStringList pluginList) {

      m_serviceProvider = new Maemo::ServiceProvider();
      m_serviceLoader = new ServiceLoader();
      m_serviceLoader->setContext(wrtPage());
      m_serviceLoader->setServiceProvider(m_serviceProvider);

      m_launcher = new Maemo::ApplicationLauncher(this);

      //Set the link following policy

      // Not needed, because schemehandler fallback provides launchUrl
      // connect(wrtPage(), SIGNAL(linkClicked(const QUrl&)),
      //        m_launcher, SLOT(launchUrl(const QUrl&)));

      m_serviceProvider->setFeatures( pluginList );
      m_serviceProvider->handleNewInstance(m_serviceLoader);

      //Create the application Launcher
      QObject* launcherPlugin = m_serviceProvider->getPluginObjectByName("LauncherApp");
      if (launcherPlugin) {
          //Connect the applet launcher to plugin
          connect(launcherPlugin,
                  SIGNAL(startApp(QString,QStringList)),
                  m_launcher,
                  SLOT(launchApplication(QString,QStringList)));
          connect(launcherPlugin,
                  SIGNAL(startApp(const QUrl&)),
                  m_launcher,
                  SLOT(launchUrl(const QUrl&)));
      }
      else {
          qWarning()<<"Plugin named LauncherApp not found in "<<Q_FUNC_INFO;
      }

  }
#endif

  QObject* WidgetContainerMaemo::pluginObject(QString name) {
      return m_serviceProvider->getPluginObjectByName(name);
  }

  void WidgetContainerMaemo::setHttpProxy() {

      QStringList environment = QProcess::systemEnvironment();
      QStringList filtered = environment.filter("http_proxy");

      if (filtered.size() == 0) {

          // NOTE: Does CWRT create WrtSettings automatically somewhere
          WrtSettings* storage = WrtSettings::createWrtSettings();
          if (storage->contains("framework/metadata/proxy/http")) {
              filtered = QStringList(storage->value("framework/metadata/proxy/http").toString());
          }
      }

      if (filtered.size() > 0 ) {
          //qDebug() << "parsing proxy";
          QString proxysetting = filtered.front();
          QStringList items = proxysetting.split(QRegExp("=|:|/"));
          int i = 0;
          QString host = "";
          QString port = "";

          while (i < items.size()) {
              QString item = items.at(i);
              if ( item != NULL && item != "http" && item!="http_proxy" &&
                   item != "" && item.length() > 0) {
                  host = item;
                  i++;
                  break;
              }
              i++;
          }

          while (i < items.size() ) {
              QString item = items.at(i);
              if ( item != "" && item != NULL ) {
                  port = item;
                  i++;
                  break;
              }
              i++;
          }

          bool ok;
          unsigned short val;
          val = port.toUShort(&ok );
          if (!ok) {
              val = 8080;
          }
          QNetworkProxy proxy(QNetworkProxy::HttpProxy,
                              host, val, NULL, NULL);
          wrtNetworkAccessManager()->setProxy(proxy);
      }
  }

    void WidgetContainerMaemo::initPageSettings(
        QString html5store, QString browsingCapa) {


        if (html5store.isEmpty()) {
            qWarning() << "Could not acquire widget resource path";
            return;
        }

        qDebug() << "HTML5 storage: " << html5store;

        wrtPage()->enableLocalStorage(html5store);

        if (browsingCapa == "all") {
            qDebug()<<"Enabled full browsing: All links will open in this frame";
        }
        else if (browsingCapa == "local") {
            qDebug()<<"Enabled local browsing: All local links will open in this window";
            wrtPage()->setLinkDelegationPolicy ( QWebPage::DelegateExternalLinks);
        }
        else {
            //send signal on all link clicks
            qDebug()<<"Browsing disabled: All links will be opened in external browser";
            wrtPage()->setLinkDelegationPolicy ( QWebPage::DelegateAllLinks);
        }

        //Set delegated link handling policy
        m_schemeHandler = new SchemeHandler();
        connect(wrtPage(), SIGNAL(linkClicked(const QUrl&)),
                m_schemeHandler, SLOT(openUrl(const QUrl&)));
        connect(m_schemeHandler, SIGNAL(linkClickedFallback(const QUrl&)),
                 m_launcher, SLOT(launchUrl(const QUrl&)));

        // Proxy needs to set after caching settings
        setHttpProxy();
    }

}
