/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifndef M_SERVICEPROVIDER_HH
#define M_SERVICEPROVIDER_HH

#include <QStringList>

#include "serviceprovider.h"
#include "serviceloader.h"

namespace NokiaAPI{


    class JavaScriptExtensionInterface;
}



namespace WRT { namespace Maemo {

    class ServiceLoader;



    class Q_DECL_EXPORT ServiceProvider : public WRT::ServiceProvider {

        public:
            void handleNewInstance(WRT::ServiceLoader* loader);
        //    void handleNewInstance(WRT::ServiceLoader* loader, QStringList features);

            void destroyInstance(WRT::ServiceLoader* loader);
            virtual void pageOnReload();

            void setFeatures(QStringList features);

            QObject* getPluginObjectByName(QString name);
            NokiaAPI::JavaScriptExtensionInterface* getPluginByName(QString name);



        private:
            void injectCommonCode(QString resourcePathToJs);

            WRT::ServiceLoader* m_serviceLoader;

            QList<QObject*> m_plugins;
            // @todo this would be a QList or something
            QStringList m_features;

    };

}}
#endif /* M_SERVICEPROVIDER_HH */



