/*
 * Copyright (C) 2006 Nokia Corporation.
 *
 * Author:  Jonas Gastal <jgastal@profusion.mobi>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef __HD_PLUGIN_LOADER_W3C_H__
#define __HD_PLUGIN_LOADER_W3C_H__

#include <libhildondesktop/libhildondesktop.h>

G_BEGIN_DECLS

typedef struct _HDPluginLoaderW3C HDPluginLoaderW3C;
typedef struct _HDPluginLoaderW3CClass HDPluginLoaderW3CClass;
typedef struct _HDPluginLoaderW3CPrivate HDPluginLoaderW3CPrivate;

#define HD_TYPE_PLUGIN_LOADER_W3C            (hd_plugin_loader_w3c_get_type ())
#define HD_PLUGIN_LOADER_W3C(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), HD_TYPE_PLUGIN_LOADER_W3C, HDPluginLoaderW3C))
#define HD_IS_PLUGIN_LOADER_W3C(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), HD_TYPE_PLUGIN_LOADER_W3C))
#define HD_PLUGIN_LOADER_W3C_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), HD_TYPE_PLUGIN_LOADER_W3C_CLASS, HDPluginLoaderW3CClass))
#define HD_IS_PLUGIN_LOADER_W3C_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), HD_TYPE_PLUGIN_LOADER_W3C_CLASS))
#define HD_PLUGIN_LOADER_W3C_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), HD_TYPE_PLUGIN_LOADER_W3C, HDPluginLoaderW3CClass))

struct _HDPluginLoaderW3C
{
    HDPluginLoader parent;

    HDPluginLoaderW3CPrivate *priv;
};

struct _HDPluginLoaderW3CClass
{
    HDPluginLoaderClass parent_class;
};

GType  hd_plugin_loader_w3c_get_type(void);

G_END_DECLS

#endif
