/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef WRTDIALOG_H
#define WRTDIALOG_H

#include <QtGui/QDialog>


#define WRT_DIALOG_FLAGS ( Qt::FramelessWindowHint | Qt::MSWindowsFixedSizeDialogHint )


#if defined (BUILDING_DIALOGS_PROVIDER)
#    define DIALOGS_PROVIDER_EXPORT Q_DECL_EXPORT
#else
#    define DIALOGS_PROVIDER_EXPORT Q_DECL_IMPORT
#endif



class DIALOGS_PROVIDER_EXPORT WrtDialog : public QDialog
{
    Q_OBJECT

public:
    WrtDialog(QWidget *parent = 0, Qt::WindowFlags f = 0);

    void setWindowFlags(Qt::WindowFlags f);
    void setSizeGripEnabled ( bool );
};

#endif // WRTDIALOG_H
