/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef CUSTOM_SCHEME_HANDLER_H_
#define CUSTOM_SCHEME_HANDLER_H_

#include <QObject>

class QUrl;

#ifdef Q_OS_MAEMO6
namespace CallUi {
class PendingCallRequest;
}
#endif

namespace WRT {
namespace Maemo {
    /**
     * CustomSchemeHandler is the container for custom uri scheme handlers used in QDesktopServices.
     * Handlers will be registered to QDesktopServices when this class is created and
     * unregistered when it is destroyed.
     */
    class CustomSchemeHandler : public QObject {

            Q_OBJECT

        public:
            CustomSchemeHandler(QObject* parent = 0);
            ~CustomSchemeHandler();

        public slots:
            int HandleHttpScheme(const QUrl &url);
            int HandleSmsScheme(const QUrl &url);
            int HandleTelScheme(const QUrl &url);
            int HandleMailtoScheme(const QUrl &url);
            int HandleRtspScheme(const QUrl &url);

            void slotLinkClicked(const QUrl& url) const;

#ifdef Q_OS_MAEMO6
            void callRequestFinished(CallUi::PendingCallRequest*);
#endif
        private:
            void SetCustomHandlers();
            void UnsetCustomHandlers();

}; // class CustomSchemeHandler
} // namespace Maemo
} // namespace WRT
#endif //CUSTOM_SCHEME_HANDLER_H_

