/*
* ============================================================================
*  Name        : qsysinfokeys.h
*  Part of     : serviceproviders / WRT
*  Description : Output map keys defined for sysinfo service
*  Version     : %version: 1 % << Don't touch! Updated by Synergy at check-out.
*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifndef __QSYSINFOKEYS_H__
#define __QSYSINFOKEYS_H__

#include <QString>

//DBUS
//HAL BME
const QString HAL_BME_SERVICE("org.freedesktop.Hal");
const QString HAL_BME_PATH("/org/freedesktop/Hal/devices/bme");
const QString HAL_BME_IF("org.freedesktop.Hal.Device");
const QString HAL_BME_GET_PROPERTY("GetProperty");
const QString HAL_BME_CHANGE_PROPERTY("PropertyModified");
const QString HAL_BME_CHARGING("battery.rechargeable.is_charging");
const QString HAL_BME_CHARGE_LEVEL("battery.charge_level.percentage");

//Phone Net
const QString PHONENET_SERVICE("com.nokia.phone.net");
const QString PHONENET_PATH("/com/nokia/phone/net");
const QString PHONENET_IF("Phone.Net");
const QString PHONENET_GET_SIGNAL_STRENGTH("get_signal_strength");
const QString PHONENET_CHANGE_SIGNAL_STRENGTH("signal_strength_change");
const QString PHONENET_GET_REGISTR_STATUS("get_registration_status");
const QString PHONENET_REGISTR_STATUS_CHANGED("registration_status_change");
const QString PHONENET_GET_MODE("get_radio_access_technology");
const QString PHONENET_GET_OPERATOR_NAME("get_operator_name");

typedef enum
{
    NETWORK_REG_STATUS_HOME = 0,                        // CS is registered to home network
    NETWORK_REG_STATUS_ROAM,                            // CS is registered to some other network than home network
    NETWORK_REG_STATUS_ROAM_BLINK,                      // CS is registered to non-home system in a non-home area ('a' or 'b' area)
    NETWORK_REG_STATUS_NOSERV,                          // CS is not in service
    NETWORK_REG_STATUS_NOSERV_SEARCHING,                // CS is not in service, but is currently searching for service
    NETWORK_REG_STATUS_NOSERV_NOTSEARCHING,             // CS is not in service and it is not currently searching for service
    NETWORK_REG_STATUS_NOSERV_NOSIM,                    // CS is not in service due to missing SIM or missing subscription
    NETWORK_REG_STATUS_POWER_OFF = 8,                   // CS is in power off state
    NETWORK_REG_STATUS_NSPS,                            // CS is in No Service Power Save State (currently not listening to any cell)
    NETWORK_REG_STATUS_NSPS_NO_COVERAGE,                // CS is in No Service Power Save State (CS is entered to this state because there is no network coverage)
    NETWORK_REG_STATUS_NOSERV_SIM_REJECTED_BY_NW        // CS is not in service due to missing subscription
} network_reg;

typedef enum
{
    NETWORK_TYPE_HOME = 0,                              //Home network
    NETWORK_TYPE_PREFERRED,                             //Preferred network
    NETWORK_TYPE_FORBIDDEN,                             //Forbidden network
    NETWORK_TYPE_NOPREF_NOFORBIDDEN,                    //Neither preferred nor forbidden network
    NETWORK_TYPE_NO_AVAILABLE                           //No network available
} network_type;

typedef enum
{
    NETWORK_MODE_DUAL = 0,
    NETWORK_MODE_GSM,
    NETWORK_MODE_3G
} network_mode;

typedef enum
{
    NETWORK_HARDCODED_LATIN_OPER_NAME = 0,
    NETWORK_HARDCODED_USC2_OPER_NAME,
    NETWORK_NITZ_SHORT_OPER_NAME,
    NETWORK_NITZ_FULL_OPER_NAME
} network_name;

//Home Network
const QString HN_SERVICE("com.nokia.phone.SIM");
const QString HN_PATH("/com/nokia/phone/SIM");
const QString HN_IF("Phone.Sim");
const QString HN_GET_OPERATOR_NAME("get_service_provider_name");
const QString HN_GET_SERVICE_INFO("read_hplmn");

//BlueZ
const QString BLUEZ_SERVICE("org.bluez");
const QString BLUEZ_PATH("/");
const QString BLUEZ_IF_MANAGER("org.bluez.Manager");
const QString BLUEZ_IF_ADAPTER("org.bluez.Adapter");
const QString BLUEZ_GET_PATH("DefaultAdapter");
const QString BLUEZ_GET_PROPERTY("GetProperties");
const QString BLUEZ_CHANGE_PROPERTY("PropertyChanged");
const QString BLUEZ_POWERED("Powered");

//SystemInfo
const QString SYSINFO_SERVICE("com.nokia.SystemInfo");
const QString SYSINFO_PATH("/com/nokia/SystemInfo");
const QString SYSINFO_IF("com.nokia.SystemInfo");
const QString SYSINFO_GET_CONFIG("GetConfigValue");
const QString SYSINFO_FIRMWARE("/device/sw-release-ver");
const QString SYSINFO_PRODUCT_TYPE("/component/product");

//SIM
const QString SIM_SERVICE("com.nokia.phone.SIM");
const QString SIM_PATH_IMEI("/com/nokia/phone/SIM/security");
const QString SIM_PATH_IMSI("/com/nokia/phone/SIM");
const QString SIM_IF_IMEI("Phone.Sim.Security");
const QString SIM_IF_IMSI("Phone.Sim");
const QString SIM_GET_IMEI("get_imei");
const QString SIM_GET_IMSI("get_imsi");

//Input Method
const QString HAL_IM_SERVICE("org.freedesktop.Hal");
const QString HAL_IM_PATH("/org/freedesktop/Hal/Manager");
const QString HAL_IM_IF("org.freedesktop.Hal.Manager");
const QString HAL_IM_FIND_DEVICE("FindDeviceByCapability");
const QString HAL_IM_KEYPAD("input.keyboard");
const QString HAL_IM_TOUCHPAD("input.touchpad");

//Flip Open
const QString HAL_FLIP_SERVICE("org.freedesktop.Hal");
const QString HAL_FLIP_PATH("/org/freedesktop/Hal/devices/platform_slide");
const QString HAL_FLIP_IF("org.freedesktop.Hal.Device");
const QString HAL_FLIP_GET_PROPERTY("GetProperty");
const QString HAL_FLIP_CHANGE_PROPERTY("PropertyModified");
const QString HAL_FLIP_STATE("button.state.value");

//MCE
const QString MCE_SERVICE("com.nokia.mce");
const QString MCE_REQUEST_PATH("/com/nokia/mce/request");
const QString MCE_REQUEST_IF("com.nokia.mce.request");
const QString MCE_DISPLAY_GET_STATUS("get_display_status");

//Hardware
const QString HAL_HARD_SERVICE("org.freedesktop.Hal");
const QString HAL_HARD_PATH("/org/freedesktop/Hal/devices/computer");
const QString HAL_HARD_IF("org.freedesktop.Hal.Device");
const QString HAL_HARD_GET_PROPERTY("GetProperty");
const QString HAL_HARD_MANUFACTURER("system.hardware.vendor");

//Active Profile
const QString PROFILED_SERVICE("com.nokia.profiled");
const QString PROFILED_PATH("/com/nokia/profiled");
const QString PROFILED_INTERFACE("com.nokia.profiled");
const QString GET_PROFILE("get_profile");
const QString GET_VALUE("get_value");
const QString GET_VIBRATION("vibrating.alert.enabled");
const QString GET_R_VOLUME("ringing.alert.volume");
const QString GET_M_VOLUME("sms.alert.volume");


//PublicId
const QString INFO_SERVICE("com.nokia.csd.Info");
const QString INFO_PATH("/com/nokia/csd/info");
const QString INFO_INTERFACE("com.nokia.csd.Info");
const QString INFO_GETPUBLICID("GetPublicId");


//CountryName
const QString CLOCKD_SERVICE("com.nokia.clockd");
const QString CLOCKD_PATH("/com/nokia/clockd");
const QString CLOCKD_INTERFACE("com.nokia.clockd");
const QString GET_TZ("get_tz");

//WirelessConnSupport
const QString HAL_WCS_SERVICE("org.freedesktop.Hal");
const QString HAL_WCS_PATH("/org/freedesktop/Hal/Manager");
const QString HAL_WCS_IF("org.freedesktop.Hal.Manager");
const QString HAL_WCS_FIND_DEVICE("FindDeviceByCapability");
const QString HAL_WI_WLAN("net.80211");

//Supported input channels                                                 getChannel    startChannel  setChannel

const QString KChargingInp( "Charging" );                                  //sync        yes           no   !!!
const QString KBatteryLevelInp( "BatteryLevel" );                          //async/sync  yes           no   !!!
const QString KNetworkInp( "Network" );                                    //async/sync  yes           no   !!!
const QString KSignalStrengthInp( "SignalStrength" );                      //async/sync  yes           no   !!!
const QString KPhoneLanguageInp( "PhoneLanguage" );                        //sync        no            no   !!!
const QString KBluetoothOnInp( "BluetoothOn" );                            //sync        yes           no   !!!
const QString KProductTypeInp( "ProductType" );                            //sync        no            no   !!!
const QString KFirmwareVersionInp( "FirmwareVersion" );                    //sync        no            no   !!!
const QString KHomeNetworkInp( "HomeNetwork" );                            //async       no            no   !!!
const QString KIMEIInp( "IMEI" );                                          //sync        no            no   !!!
const QString KDisplayOrientationInp( "DisplayOrientation" );              //sync        no            no   !!!
const QString KDeviceInputMethodInp( "DeviceInputMethod" );                //sync        no            no   !!!
const QString KCountryNameInp( "CountryName" );                            //sync        no            no   !!!
const QString KIMSIInp( "IMSI" );                                          //sync        no            no   !!!
const QString KCellularNetworkStatusInp( "CellularNetworkStatus" );        //sync        no            no   !!!
const QString KSupportedVideoDecodersInp( "SupportedVideoDecoders" );      //sync        no            no
const QString KWirelessConnSupportInp( "WirelessConnSupport" );            //sync        no            no   !!?
const QString KActiveDataConnectionsInp( "ActiveDataConnections" );        //sync        no            no
const QString KVibrateInp( "Vibrate" );                                    //no          no            sync
const QString KFlipOpenInp( "FlipOpen" );                                  //no          yes           no   !!!
const QString KDisplayWallpaperInp( "DisplayWallpaper" ) ;                 //no          no            sync
const QString KListDrivesInp( "ListDrives" );                              //sync        no            no
const QString KListDriveInfoInp( "ListDriveInfo" );                        //sync        no            no
const QString KClipboardInp( "ClipBoard" );                                //sync        no            sync !!!
const QString KPhoneManufacturerInp( "PhoneManufacturer" );                //sync        no            no   !!!
const QString KPhoneModelInp( "PhoneModel" );                              //sync        no            no   !!!
const QString KPlatformNameInp( "PlatformName" );                          //sync        no            no   !!!
const QString KPhoneColorDepthInp( "PhoneColorDepth" );                    //sync        no            no   !!!
const QString KDisplayResolutionInp( "DisplayResolution" );                //sync        no            no   !!!
const QString KBacklightStateInp( "BacklightState" );                      //sync        no            no   !!!
const QString KKeypadLightStateInp( "KeypadLightState" );                  //sync        no            no
const QString KActiveProfileInp( "ActiveProfile" );                        //sync        no            no   !!!
const QString KMicrophoneVolumeInp( "MicrophoneVolume" );                  //sync        no            no
const QString KSpeakerVolumeInp( "SpeakerVolume" );                        //sync        no            no
const QString KPublicIDInp( "PublicId" );                                  //sync        no            no   !!!

//Output keys
const QString KChargingStatus( "chargingStatus" );
const QString KBatteryLevel( "batteryLevel" );

const QString KNetworkName( "networkName" );
const QString KNetworkStatus( "networkStatus" );
const QString KNetworkMode( "networkMode" );
const QString KMobileCountryCode( "mobileCountryCode" );
const QString KNetworkCode( "mobileNetworkCode" );
const QString KLocationStatus( "locationStatus" );
const QString KAreaCode( "areaCode" );
const QString KCellID( "cellID" );

const QString KSignalStrength( "signalStrength" );
const QString KPhoneLanguage( "phoneLanguage" );
const QString KBtOn( "btOn" );
const QString KProductType( "productType" );
const QString KFirmwareVersion( "firmwareVersion" );
const QString KHomeNetwork( "homeNetwork" );
const QString KIMEI( "imei" );
const QString KDisplayOrientation( "displayOrientation" );
const QString KDeviceInputMethod( "deviceInputMethod" );
const QString KCountryName( "countryName" );
const QString KIMSI( "imsi" );
const QString KCellularNetworkStatus( "cellularNetworkStatus" );

const QString Kmanufacturer ( "manufacturer" );
const QString Kidentifier ( "identifier" );
const QString KmaxBitrate ( "maxBitrate" );
const QString KisHWAccelerationEnabled ( "isHWAccelerationEnabled" );
const QString Kversion ( "version" );
const QLatin1String  GST_CODEC_TYPE_VIDEO("Codec/Decoder/Video");
const QLatin1String  GST_CODEC_TYPE_AUDIO("Codec/Decoder/Audio");

const QString KWirelessConnSupport( "connectionTypes" );

const QString KConnectionType( "connectionType" );
const QString KConnectionName( "connectionName" );

const QString KVibrate( "vibrate" );
const QString KFlipOpen( "flipOpen" );
const QString KDisplayWallpaper( "displayWallpaper" ) ;
const QString KListOfDrives ("listOfDrives");
const QString KInfoDriveName ("DriveName");
const QString KCriticalMemory( "criticalMemory" );
const QString KClipboard( "clipBoardData" );
const QString KPhoneManufacturer( "phoneManufacturer" );
const QString KPhoneModel( "phoneModel" );
const QString KPlatformName( "platformName" );
const QString KPhoneColorDepth( "phoneColorDepth" );

const QString KHeightDisplay( "height" );
const QString KWidthDisplay( "width" );

const QString KBacklightState( "backLightOn" );
const QString KKeypadLightState( "keypadLightOn" );

const QString KMsgRingtoneVolume( "msgRingtoneVolume" );
const QString KRingtoneVolume( "ringtoneVolume" );
const QString KVibrationActive( "vibrationActive" );

const QString KMicrophoneVolume( "microphoneVolume" );
const QString KSpeakerVolume( "speakerVolume" );
const QString KPublicID( "publicId" );


//Output value

//Input map keys for set channel
const QString KWallpaperFileurl( "wallpaperFileurl" );
const QString KVibraDurationSecs( "vibraDurationSecs" );
const QString KVibraIntensity( "Intensity" );
const QString KVibraEnable( "EnableVibra" );
const QString KClipboardString ("clipboardString");


//Network mode output literals
const QString KModeGsm("ModeGsm" );
const QString KMode3G ("ModeWcdma" );
//const QString KModeCdma("ModeCdma" );

//Network status output literals
const QString KAvailable("Available" );
const QString KCurrent("Current" );
const QString KForbidden("Forbidden" );
const QString KUnknown("Unknown");

//Roaming flag output literals
const QString KRegisteredOnHomeNetwork("RegisteredOnHomeNetwork" );
const QString KRegisteredRoaming("RegisteredRoaming" );
const QString KNotRegisteredNoService("NotRegisteredNoService" );
const QString KNotRegisteredSearching("NotRegisteredSearching" );
const QString KNotRegisteredEmergencyOnly("NotRegisteredEmergencyOnly" );
const QString KRegistrationDenied("RegistrationDenied" );
const QString KRegistrationUnknown("RegistrationUnknown" );
const QString KRegisteredBusy("RegisteredBusy" );

//Wireless Connection output literals
const QString WI_NAME_BLUETOOTH ( "Bluetooth");
const QString WI_NAME_IRDA ( "Irda" );
const QString WI_NAME_WLAN ( "Wlan" );
const QString WI_NAME_GSM ( "Gsm" );
const QString WI_NAME_WCDMA ( "Wcdma" );
const QString WI_NAME_CDMA ( "Cdma" );

//Device input method output keys
const QString KTouch("Touch" );
const QString KNonTouch("NonTouch" );
const QString KDual("Hybrid" );

//Display orientation output keys
const QString KLandscape("Landscape" );
const QString KPortrait("Portrait" );


//Error code key and Error message
const QString KErrCode( "errCode" );
const QString KErrMessage( "errMessage" );

//DBus error
const QString KErrDBusIf( ":error create interace" );
const QString KErrDBusMsg( ":type msg not reply" );
const QString KErrDBusCb( ":error of CB" );
const QString KErrDBusCon( ":error of connect" );

//Modes
const QString m_getChannelList("getChannelList");
const QString m_setChannelSync("setChannelSync");
const QString m_getChannelSync("getChannelSync");
const QString m_getChannelASync("getChannelASync");
const QString m_cancel("cancel");
const QString m_startChannel("startChannel");
const QString m_stopChannel("stopChannel");
const QString m_dbusErrors("dbusErrors");
const QString m_setWallpaper("setWallpaper");

//Error messages
const QString KStrErrMissingArg( "Missing input argument" );
const QString KStrErrInvalidKey( "Unsupported input argument" );
const QString KStrErrInvalidTransID( "Transaction id is invalid" );
const QString KStrErrReadingGetInfo( "Error in getting data" );
const QString KStrErrTrigger( "Trigger values are out of range" );
const QString KStrErrStop( "Attempt to stop non-existing notification" );
const QString KStrErrPermission( "Security check failed for input argument" );

//Error codes
const int MISSING_ARG_ERR                 = 1;
const int INVALID_ARG_ERR                 = 2;
const int NOT_SUPPORTED_ERR               = 3;
const int SERVICE_NOT_AVAILABLE           = 4;

const int TIMEOUT_ERR                    = 100;
const int DATA_NOT_FOUND_ERR             = 101;
const int DATA_ALREADY_EXISTS_ERR        = 102;

const int SERVICE_BUSY_ERR               = 103;
const int SERVICE_IN_USE_ERR             = 104;

const int DATA_OUT_OF_RANGE_ERR          = 105;
const int NOT_ALLOWED_ERR                = 106;
const int SIZE_EXCEEDED_ERR              = 107;

const int INVALID_URI_ERR                = 108;
const int URI_NOT_FOUND_ERR              = 109;
const int URI_ALREADY_EXISTS_ERR         = 110;

#endif //__QSYSINFOKEYS_H__
