/*
* ============================================================================
*  Name        : listdriveinfo.h
*  Part of     : serviceproviders / WRT
*  Description : Qt class for ListDriveInfo channel
*  Version     : %version: 1 % << Don't touch! Updated by Synergy at check-out.
*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef LISTDRIVEINFO_H
#define LISTDRIVEINFO_H

#include <QMap>
#include <QString>
#include <QList>
#include <QVariant>
#include <QStringList>

//driveinfo dataschema members
const QString DriveUrl("driveUrl");
const QString DriveName("driveName");
const QString TotalMemory("totalMemory");
const QString FreeMemory("freeMemory");
const QString CritcalMemory("criticalMemory");
const QString IsRemovableMedia("isRemovableMedia");
const QString MediaType("mediaType");

//dbus services
const QString HAL_SERVICE("org.freedesktop.Hal");
const QString HAL_PATH("/org/freedesktop/Hal/Manager");
const QString HAL_INTERFACE("org.freedesktop.Hal.Manager");
const QString HAL_DEVICE_INTERFACE("org.freedesktop.Hal.Device");

//hal dbus calls
const QString HALCallGetProperty("GetProperty");
const QString HALCallFindDeviceStringMatch("FindDeviceStringMatch");
const QString HALCallFindDeviceByCapability("FindDeviceByCapability");

//hal dbus arguments
//Volumes
const QString HALArgVolume("volume");
const QString HALArgVolume_MountPoint("volume.mount_point");
const QString HALArgVolume_Size("volume.size");
const QString HALArgVolume_UUID("volume.uuid");
//Blocks
const QString HALArgBlock_StorageDevice("block.storage_device");
//Storages
const QString HALArgStorage_Removable_MediaAvailable("storage.removable.media_available");
const QString HALArgStorage_DriveType("storage.drive_type");

//media disk types
const QString MediaHardDisk("MediaHardDisk");
const QString MediaCdRom("MediaCdRom");
const QString MediaFloppyDisk("MediaFloppyDisk");
const QString MediaNotPresent("MediaNotPresent");
const QString MediaFlash("MediaFlash");
const QString MediaUnknown("MediaUnknown");
const QString MediaRemote("MediaRemote");
const QString MediaRom("MediaRom");
const QString MediaRam("MediaRam");

//hal drive_types
const QString HALMediaDisk("disk");
const QString HALMediaCdrom("cdrom");
const QString HALMediaFloppy("floppy");
const QString HALMediaTape("tape");
const QString HALMediaCompactFlash("compact_flash");
const QString HALMediaMemoryStick("memory_stick");
const QString HALMediaSmartMedia("smart_media");
const QString HALMediaSD_MMC("sd_mmc");

//volume properties
const QString VolPropDriveUrl("driveUrl");
const QString VolPropDriveName("driveName");
const QString VolPropTotalMemory("totalMemory");
const QString VolPropFreeMemory("freeMemory");
const QString VolPropCritcalMemory("critcalMemory");
const QString VolPropIsRemovableMedia("isRemovableMedia");
const QString VolPropMediaType("mediaType");
const QString VolPropTotalMemoryNonMounted("totalMemoryNonMounted");

//none filesystem name
const QString NoneFileSystem("none");

class ListDriveInfo
{
private:
    //Use #include <linux/magic.h> instead this hardcode
    typedef enum
    {
        ADFS_SUPER_MAGIC     = 0xadf5,
        AFFS_SUPER_MAGIC     = 0xADFF,
        BEFS_SUPER_MAGIC     = 0x42465331,
        BFS_MAGIC            = 0x1BADFACE,
        CIFS_MAGIC_NUMBER    = 0xFF534D42,
        CODA_SUPER_MAGIC     = 0x73757245,
        COH_SUPER_MAGIC      = 0x012FF7B7,
        CRAMFS_MAGIC         = 0x28cd3d45,
        DEVFS_SUPER_MAGIC    = 0x1373,
        EFS_SUPER_MAGIC      = 0x00414A53,
        EXT_SUPER_MAGIC      = 0x137D,
        EXT2_OLD_SUPER_MAGIC = 0xEF51,
        EXT2_SUPER_MAGIC     = 0xEF53,
        EXT3_SUPER_MAGIC     = 0xEF53,
        HFS_SUPER_MAGIC      = 0x4244,
        HPFS_SUPER_MAGIC     = 0xF995E849,
        HUGETLBFS_MAGIC      = 0x958458f6,
        ISOFS_SUPER_MAGIC    = 0x9660,
        JFFS2_SUPER_MAGIC    = 0x72b6,
        JFS_SUPER_MAGIC      = 0x3153464a,
        MINIX_SUPER_MAGIC    = 0x137F, /* orig. minix */
        MINIX_SUPER_MAGIC2   = 0x138F, /* 30 char minix */
        MINIX2_SUPER_MAGIC   = 0x2468, /* minix V2 */
        MINIX2_SUPER_MAGIC2  = 0x2478, /* minix V2, 30 char names */
        MSDOS_SUPER_MAGIC    = 0x4d44,
        NCP_SUPER_MAGIC      = 0x564c,
        NFS_SUPER_MAGIC      = 0x6969,
        NTFS_SB_MAGIC        = 0x5346544e,
        OPENPROM_SUPER_MAGIC = 0x9fa1,
        PROC_SUPER_MAGIC     = 0x9fa0,
        QNX4_SUPER_MAGIC     = 0x002f,
        REISERFS_SUPER_MAGIC = 0x52654973,
        ROMFS_MAGIC          = 0x7275,
        SMB_SUPER_MAGIC      = 0x517B,
        SYSV2_SUPER_MAGIC    = 0x012FF7B6,
        SYSV4_SUPER_MAGIC    = 0x012FF7B5,
        TMPFS_MAGIC          = 0x01021994,
        UDF_SUPER_MAGIC      = 0x15013346,
        UFS_MAGIC            = 0x00011954,
        USBDEVICE_SUPER_MAGIC= 0x9fa2,
        VXFS_SUPER_MAGIC     = 0xa501FCF5,
        XENIX_SUPER_MAGIC    = 0x012FF7B4,
        XFS_SUPER_MAGIC      = 0x58465342,
        _XIAFS_SUPER_MAGIC   = 0x012FD16D,
        UBIFS_SUPER_MAGIC    = 0x24051905,
        SYSFS_MAGIC          = 0x62656572,
        DEVPTS_SUPER_MAGIC   = 0x1cd1,
        S_MAGIC_SECURITYFS   = 0x73636673
    } fstypescompletelist_t;

    typedef enum
    {
        eStatfsFreeSpaceProp,
        eStatfsCriticalSpaceProp,
        eStatfsFullSpaceProp,
        eStatfsFSTypeProp
    } statfsprops_t;


public:
    ListDriveInfo();
    ~ListDriveInfo();
    void init();
    QMap<QString, QVariant> getInfo(const QString& name);
    QList<QString> getNames();
private:
    QStringList getVolumes();
    QStringList getMountPoints();

    QVariant volumeProperty(const QString& drive, const QString& prop);
    QVariant volumeHalProperty(const QString& drive, const QString& prop);
    QVariant storageHalProperty(const QString& drive, const QString& prop);
    QVariant getStatfsProperty(const QString& mountPoint, statfsprops_t prop);

    QString getDriveName(const QString& mountPoint);
    QString blockDevice(const QString& mountPoint);

    QMap<QString, QString> m_mediaTypes;
    QList<QMap<QString, QVariant> > m_fullInfo;
};

#endif // LISTDRIVEINFO_H
