# Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
#
# This file is part of Qt Web Runtime.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public License
# version 2.1 as published by the Free Software Foundation.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
#

TEMPLATE = lib

CONFIG += plugin

symbian {
    CONFIG(debug):SENSORSVC_SRC_PATH = ./platform/s60/
    CONFIG(debug):SENSORSVC_INC_PATH = ./platform/s60/
    CONFIG(release):SENSORSVC_SRC_PATH = ./platform/s60/
    CONFIG(release):SENSORSVC_INC_PATH = ./platform/s60/
}
maemo {
  maemo5 {
    CONFIG(debug):SENSORSVC_SRC_PATH = ./platform/maemo5/
    CONFIG(debug):SENSORSVC_INC_PATH = ./platform/maemo5/
    CONFIG(release):SENSORSVC_SRC_PATH = ./platform/maemo5/
    CONFIG(release):SENSORSVC_INC_PATH = ./platform/maemo5/
    CONFIG(release):DEFINES += QT_NO_DEBUG_OUTPUT
  }
  else{
    CONFIG(debug):SENSORSVC_SRC_PATH = ./platform/maemo/
    CONFIG(debug):SENSORSVC_INC_PATH = ./platform/maemo/
    CONFIG(release):SENSORSVC_SRC_PATH = ./platform/maemo/
    CONFIG(release):SENSORSVC_INC_PATH = ./platform/maemo/
  }
}

symbian {
HEADERS = $$SENSORSVC_INC_PATH/qsensorkeys.h \
					$$SENSORSVC_INC_PATH/sensorservice.h \
					$$SENSORSVC_INC_PATH/sensorservice.hrh \
					$$SENSORSVC_INC_PATH/sensorchanneldatasync.h \
					$$SENSORSVC_INC_PATH/qsensorservice.h \
    			qsensorserviceplugin.h \
   				qsensorserviceinterface.h \
    
SOURCES = $$SENSORSVC_SRC_PATH/sensorservice.cpp \
					$$SENSORSVC_SRC_PATH/sensorchanneldatasync.cpp \
					$$SENSORSVC_SRC_PATH/qsensorservice.cpp \
    			qsensorserviceplugin.cpp \
}
maemo { 
  maemo5 {
    DEFINES += __MAEMO__
    HEADERS = $$SENSORSVC_INC_PATH/qsensorservice.h \
              $$SENSORSVC_INC_PATH/qsensordefines.h \
              qsensorserviceplugin.h \
              qsensorserviceinterface.h

    SOURCES = $$SENSORSVC_SRC_PATH/qsensorservice.cpp \
              qsensorserviceplugin.cpp
  }
  else {
    DEFINES += __MAEMO__
    HEADERS = $$SENSORSVC_INC_PATH/qstartchnltask.h \
              $$SENSORSVC_INC_PATH/qsensorservice.h \
              $$SENSORSVC_INC_PATH/qsensordefines.h \
              qsensorserviceplugin.h \
              qsensorserviceinterface.h

    SOURCES = $$SENSORSVC_SRC_PATH/qsensorservice.cpp \
              $$SENSORSVC_SRC_PATH/qstartchnltask.cpp \
              qsensorserviceplugin.cpp
  }
}

TARGET = WrtApiSensor
include(../cwrtservice.pri)
INCLUDEPATH += \ecwrt\inc

symbian { 
    TARGET.CAPABILITY = ALL \
        -TCB
    TARGET.EPOCALLOWDLLDATA = 1
    TARGET.UID3 = 0x20026155
    LIBS += -lefsrv \
        -lplatformenv \
        -lsensrvclient \
        -lsensrvutil
   	VERSION = 3.0.0
   
    TARGET.sources = ./descriptionxml/sensorserviceplugin.xml
    TARGET.path = /private/102829B8/import
    DEPLOYMENT += TARGET
    #QMAKE_POST_LINK += xcopy .\\qmakepluginstubs  \\epoc32\\data\\Z\\resource\\qt\\sfwplugin /H /I /E
}
maemo {
  maemo5 {
    QT += dbus

    # Build against wrt-dev package
    cwrt-services {
        LIBS += -L/usr/lib -lWrtSecurityManager
        INCLUDEPATH += /usr/include/cwrt/security
        INCLUDEPATH += /usr/include/cwrt/servicefw
    }

    TARGET.sources = ./descriptionxml/sensorserviceplugin.xml
    INCLUDEPATH += $$CWRT_INCLUDE \
                   $$SENSORSVC_INC_PATH
  }
  else {
    LIBS += -lqmsystem

    TARGET.sources = ./descriptionxml/sensorserviceplugin.xml
    INCLUDEPATH += $$CWRT_INCLUDE \
                   $$SENSORSVC_INC_PATH \
                   /usr/include/qmsystem \
                   /usr/include/sensord \
                   /usr/include/qt4/QtDBus
  }
}
