# Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
#
# This file is part of Qt Web Runtime.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public License
# version 2.1 as published by the Free Software Foundation.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
#

TEMPLATE = lib
CONFIG += plugin
!maemo5 {
LIBS += -lsecmgr
}
maemo5 {
LIBS += -lWrtSecurityManager
}
symbian {
    CONFIG(debug):MESSAGINGSVC_SRC_PATH = ./platform/s60/
    CONFIG(debug):MESSAGINGSVC_INC_PATH = ./platform/s60/
    CONFIG(release):MESSAGINGSVC_SRC_PATH = ./platform/s60/
    CONFIG(release):MESSAGINGSVC_INC_PATH = ./platform/s60/

    HEADERS = $$MESSAGINGSVC_INC_PATH/accessfolder.h \
                $$MESSAGINGSVC_INC_PATH/changestatus.h \
                $$MESSAGINGSVC_INC_PATH/messagedetail.h \
                $$MESSAGINGSVC_INC_PATH/messageheader.h \
                $$MESSAGINGSVC_INC_PATH/messagenotify.h \
                $$MESSAGINGSVC_INC_PATH/messagingservice.h \
                $$MESSAGINGSVC_INC_PATH/sendmessage.h \
                $$MESSAGINGSVC_INC_PATH/qmessagingservice.h \
                $$MESSAGINGSVC_INC_PATH/qmessagingiterator.h \
                $$MESSAGINGSVC_INC_PATH/qmessagingconstants.h \
                ./qmessagingserviceplugin.h \
                ./qmessagingserviceinterface.h


    SOURCES = $$MESSAGINGSVC_SRC_PATH/accessfolder.cpp \
                $$MESSAGINGSVC_SRC_PATH/messagedetail.cpp \
                $$MESSAGINGSVC_SRC_PATH/changestatus.cpp \
                $$MESSAGINGSVC_SRC_PATH/messageheader.cpp \
                $$MESSAGINGSVC_SRC_PATH/messagenotify.cpp \
                $$MESSAGINGSVC_SRC_PATH/messagingservice.cpp \
                $$MESSAGINGSVC_SRC_PATH/sendmessage.cpp \
                $$MESSAGINGSVC_SRC_PATH/qmessagingservice.cpp \
                $$MESSAGINGSVC_SRC_PATH/qmessagingiterator.cpp \
                ./qmessagingserviceplugin.cpp
}

maemo {

  maemo5 {
    DEFINES += __MAEMO__
    CONFIG(debug):MESSAGINGSVC_SRC_PATH = ./platform/maemo5/
    CONFIG(debug):MESSAGINGSVC_INC_PATH = ./platform/maemo5/
    CONFIG(release):MESSAGINGSVC_SRC_PATH = ./platform/maemo5/
    CONFIG(release):MESSAGINGSVC_INC_PATH = ./platform/maemo5/
    CONFIG(release):DEFINES += QT_NO_DEBUG_OUTPUT
    HEADERS = $$MESSAGINGSVC_INC_PATH/qmessagingservice.h \
        ./qmessagingserviceplugin.h \
        ./qmessagingserviceinterface.h \
        $$MESSAGINGSVC_INC_PATH/qmessagingiterator.h \
        $$MESSAGINGSVC_INC_PATH/qmessagingconstants.h \
        $$MESSAGINGSVC_INC_PATH/getmsglisttask.h \
        $$MESSAGINGSVC_INC_PATH/messagefilter.h \
        $$MESSAGINGSVC_INC_PATH/messagedata.h \
        $$MESSAGINGSVC_INC_PATH/sendmessage.h
    SOURCES = ./qmessagingserviceplugin.cpp \
        $$MESSAGINGSVC_SRC_PATH/qmessagingservice.cpp \
        $$MESSAGINGSVC_SRC_PATH/qmessagingiterator.cpp \
        $$MESSAGINGSVC_SRC_PATH/getmsglisttask.cpp \
        $$MESSAGINGSVC_SRC_PATH/messagefilter.cpp \
        $$MESSAGINGSVC_SRC_PATH/messagedata.cpp \
        $$MESSAGINGSVC_SRC_PATH/sendmessage.cpp
  } else {
    DEFINES += __MAEMO__
    CONFIG(debug):MESSAGINGSVC_SRC_PATH = ./platform/maemo/
    CONFIG(debug):MESSAGINGSVC_INC_PATH = ./platform/maemo/
    CONFIG(release):MESSAGINGSVC_SRC_PATH = ./platform/maemo/
    CONFIG(release):MESSAGINGSVC_INC_PATH = ./platform/maemo/
    HEADERS = $$MESSAGINGSVC_INC_PATH/qmessagingservice.h \
        ./qmessagingserviceplugin.h \
        ./qmessagingserviceinterface.h \
        $$MESSAGINGSVC_INC_PATH/qmessagingiterator.h \
        $$MESSAGINGSVC_INC_PATH/qmessagingconstants.h \
        $$MESSAGINGSVC_INC_PATH/getmsglisttask.h \
        $$MESSAGINGSVC_INC_PATH/messagefilter.h \
        $$MESSAGINGSVC_INC_PATH/messagedata.h \
        $$MESSAGINGSVC_INC_PATH/qemailmanager.h \
        $$MESSAGINGSVC_INC_PATH/qmsgcontactmanager.h \
        $$MESSAGINGSVC_INC_PATH/commhistorymessagemodel.h \
        $$MESSAGINGSVC_INC_PATH/sendemail.h \
        $$MESSAGINGSVC_INC_PATH/sendmessage.h
    SOURCES = ./qmessagingserviceplugin.cpp \
        $$MESSAGINGSVC_SRC_PATH/qmessagingservice.cpp \
        $$MESSAGINGSVC_SRC_PATH/qmessagingiterator.cpp \
        $$MESSAGINGSVC_SRC_PATH/getmsglisttask.cpp \
        $$MESSAGINGSVC_SRC_PATH/messagefilter.cpp \
        $$MESSAGINGSVC_SRC_PATH/messagedata.cpp \
        $$MESSAGINGSVC_SRC_PATH/qemailmanager.cpp \
        $$MESSAGINGSVC_SRC_PATH/qmsgcontactmanager.cpp \
        $$MESSAGINGSVC_SRC_PATH/commhistorymessagemodel.cpp \
        $$MESSAGINGSVC_SRC_PATH/sendemail.cpp \
        $$MESSAGINGSVC_SRC_PATH/sendmessage.cpp
  }
}

contains( what, ninetwo ) {
HEADERS +=  $$MESSAGINGSVC_INC_PATH/emailaccount.h \
                         $$MESSAGINGSVC_INC_PATH/emailclient.h \
                         $$MESSAGINGSVC_INC_PATH/qemailiterator.h \
                         $$MESSAGINGSVC_INC_PATH/emailmessage.h \
                         $$MESSAGINGSVC_INC_PATH/iteratorcleanup.h 
SOURCES += $$MESSAGINGSVC_SRC_PATH/emailaccount.cpp \
                        $$MESSAGINGSVC_SRC_PATH/emailclient.cpp \
                        $$MESSAGINGSVC_SRC_PATH/qemailiterator.cpp \
                        $$MESSAGINGSVC_INC_PATH/iteratorcleanup.cpp 

DEFINES += CWRT_BUILDING_NINETWO
}
contains( what, tenone ) {
HEADERS +=  $$MESSAGINGSVC_INC_PATH/emailaccount.h \
                         $$MESSAGINGSVC_INC_PATH/emailclient.h \
                         $$MESSAGINGSVC_INC_PATH/qemailiterator.h \
                         $$MESSAGINGSVC_INC_PATH/emailmessage.h

SOURCES += $$MESSAGINGSVC_SRC_PATH/emailaccount.cpp \
                        $$MESSAGINGSVC_SRC_PATH/emailclient.cpp \
                        $$MESSAGINGSVC_SRC_PATH/qemailiterator.cpp

DEFINES += CWRT_BUILDING_TENONE
}

TARGET = WrtApiMessaging

include(../cwrtservice.pri)
INCLUDEPATH += \ecwrt\inc
symbian {
    TARGET.CAPABILITY = ALL \
        -TCB
    TARGET.EPOCALLOWDLLDATA = 1
    TARGET.UID3 = 0x2002614E
    LIBS += -lefsrv \
        -lplatformenv \
        -lmsgs \
        -leuser \
        -lbafl \
        -leikcore \
        -lcone \
        -lsendas2 \
        -letext \
        -lapgrfx \
        -lapmime \
        -linetprotutil \
        -lsmcm \
        -lcharconv \
        -lecom \
        -lmtur \
        -lgsmu

    VERSION = 3.0.0

    TARGET.sources = ./descriptionxml/messagingserviceplugin.xml
    TARGET.path = /private/102829B8/import
    DEPLOYMENT += TARGET
  #  QMAKE_POST_LINK += xcopy .\\qmakepluginstubs  \\epoc32\\data\\Z\\resource\\qt\\sfwplugin /H /I /E

}

maemo {

  maemo5 {

    CONFIG += mobility
    MOBILITY += messaging

    LIBS += -L$$MAEMO_HOME/maemowrt
    LIBS += -lglib-2.0
    LIBS += -lhildonmime

    # Build against wrt-dev package
    cwrt-services {
        INCLUDEPATH -= ../../../inc
        INCLUDEPATH += /usr/include/cwrt/security
        INCLUDEPATH += /usr/include/cwrt/servicefw
    }

        INCLUDEPATH += $$CWRT_INCLUDE \
        $$MAEMO_HOME/services \
        $$MAEMO_HOME/utils \
        $$MESSAGINGSVC_INC_PATH \
        /usr/include/glib-2.0/ \
        /usr/lib/glib-2.0/include/ \
        /usr/include/
  } else {

    LIBS += -lmessagingif0
    LIBS += -lcommhistory
    LIBS += -lqmfutil
    LIBS += -lQtContacts

    CONFIG += mobility
    MOBILITY +=contacts

    INCLUDEPATH += $$CWRT_INCLUDE \
        $$MESSAGINGSVC_INC_PATH \
        /usr/include/qt4/ \
        /usr/include/qt4/QtSql \
        /usr/include/qt4/QtContacts \
        /usr/include/messaging-service/ \
        /usr/include/commhistory/ \
        /usr/include/qmf/ \
        /usr/include/meegotouch/

    INCLUDEPATH    += ../../inc
    # Export description file
    EXPORT_FILE_NAME_BASE = messagingserviceplugin

    EXPORT_DIR = $$DESTDIR/import/
    EXPORT_SRC = descriptionxml/$$EXPORT_FILE_NAME_BASE.xml
    EXPORT_DST = $$EXPORT_DIR$$EXPORT_FILE_NAME_BASE.xml
    export_files_cmd.input = $$EXPORT_SRC
    export_files_cmd.output = $$EXPORT_DST
    export_files_cmd.commands = $(COPY) $$EXPORT_SRC $$EXPORT_DST
    export_files_cmd.CONFIG = target_predeps no_link
    export_files_cmd.clean = $$EXPORT_DST
    QMAKE_EXTRA_COMPILERS += export_files_cmd
  }
}
