/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifndef __MESSAGINGCONSTANTS_H__
#define __MESSAGINGCONSTANTS_H__

#include <QString>

//Error code key
const QString KCErrorCode( "ErrorCode" );
//Error message
const QString KCErrorMessage( "ErrorMessage" );
//Return Value
const QString KCReturnValue( "ReturnValue" );
const QString KCTransactionId("TransactionId");

const int KMaxSubjectLength = 255;
const int KMaxAttachmentUriLength = 255;


//Error codes
const int SUCCESS                         = 0;
const int MISSING_ARG_ERR                 = 1;
const int INVALID_ARG_ERR                 = 2;
const int NOT_SUPPORTED_ERR               = 3;
const int TIMEOUT_ERR                    = 100;
const int DATA_NOT_FOUND_ERR             = 101;
const int DATA_ALREADY_EXISTS_ERR        = 102;
const int SERVICE_BUSY_ERR               = 103;
const int SERVICE_IN_USE_ERR             = 104;
const int DATA_OUT_OF_RANGE_ERR          = 105;
const int NOT_ALLOWED_ERR                = 106;
const int SIZE_EXCEEDED_ERR              = 107;
const int INVALID_URI_ERR                = 108;
const int URI_NOT_FOUND_ERR              = 109;
const int URI_ALREADY_EXISTS_ERR         = 110;
//Messaging Domain Specific Error
const int NO_NETWORK_ERR                 = 500;


//General Error Messages
const QString KCSuccess("Success");
const QString KCBadArgument("Invalid Argument or Out of range value");
const QString KCNotSupported("Not supported");
const QString KCServiceInUse("Service already in Use");
const QString KCServiceBusy("Service is busy");
const QString KCNotAllowed("Operation is not allowed");
const QString KCDataExists("Data already exists");
const QString KCDataNotFound("Data not found");
const QString KCInvalidId("messageId is out of range value");
const QString KCMissingArg("Mandatory parameter missing");
const QString KCBadDataType("Invalid data type");
const QString KCGeneral("General error");
const QString KCPathNotFound("Path or URI not found");
const QString KCInvalidUri("Invalid URI Format");
const QString KCTimeOut("Time Out Error");
const QString KCNoNetwork("Network not available");

//Message Data
const QString KCRecipientNumber = "recipient";
const QString KCType    = "type";
const QString KCTo      = "to";
const QString KCContactId = "contactid";
const QString KCBody    = "body";
const QString KCSubject = "subject";
const QString KCCc      = "cc";
const QString KCBcc      = "bcc";
const QString KCAttachment  = "attachments";
const QString KCUri     = "uri";
const QString KCSMS     = "SMS";
const QString KCMMS     = "MMS";
const QString KCEMAIL     = "EMAIL";
const QString KCSenders = "senders";
const QString KCSender  = "sender";
const QString KCStart   = "start";
const QString KCEnd     = "end";
const QString KCID      = "id";
const QString KCTIME    = "time";
const QString KCUNREAD  = "unread";
const QString KCMessage = "message";
const QString KCFolder = "folder";
const QString KCAccountId =   "accountid";
const QString KCAccountName =   "accountname";
const QString KCMessagePriority = "priority";
const QString KCValidity = "validity";
const QString KCMimeType = "mimetype"; // TODO: support this
const QString KCSize = "filesize";     // TODO: support this
const QString KCMessageMap = "MessageMap";
const QString KCErrorMap = "ErrorMap";

const QString KCINBOX = "inbox";
const QString KCDRAFTS = "drafts";
const QString KCSENTBOX = "sentbox";
const QString KCOUTBOX = "outbox";
const QString KCALL = "all";

const int BASE10    = 10;

const int SORT_BY_DATE = 0;
const int SORT_BY_SENDER = 1;

const int SORT_ASCENDING = 0;
const int SORT_DESCENDING = 1;

const int MESSAGE_READ = 0;
const int MESSAGE_UNREAD = 1;

const int PRIORITY_HIGH = 0;
const int PRIORITY_NORMAL = 1;
const int PRIORITY_LOW = 2;

#endif //__MESSAGINGCONSTANTS_H__
