/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef RDFSELECT_H
#define RDFSELECT_H

#include <QDateTime>
#include <QStringList>
#include <QVariantList>
#include <QString>

const QString MPrefixAudio          = "Audio:";
const QString MPrefixVideo          = "Video:";
const QString MPrefixImage          = "Image:";
const QString MPrefixFile           = "File:";

const QString MFieldTitle           = "Title";
const QString MFieldArtist          = "Artist";
const QString MFieldAlbum           = "Album";
const QString MFieldGenre           = "Genre";
const QString MFieldTrack           = "TrackNo";
const QString MFieldComposer        = "Composer";
const QString MFieldDuration        = "Duration";

const QString MFieldCameraMake      = "CameraMake";
const QString MFieldCameraModel     = "CameraModel";
const QString MFieldISOSpeed        = "ISOSpeed";
const QString MFieldFNumber         = "FNumber";
const QString MFieldFocalLenght     = "FocalLength";
const QString MFieldOrientation     = "Orientation";
const QString MFieldMeteringMode    = "MeteringMode";
const QString MFieldFlash           = "Flash";
const QString MFieldWhiteBalance    = "WhiteBalance";
const QString MFieldExposureTime    = "ExposureTime";
const QString MFieldOriginalDate    = "Date";

const QString MFieldSize            = "Size";
const QString MFieldDate            = "Modified";
const QString MFieldName            = "Name";
const QString MFieldWidth           = "Width";
const QString MFieldHeight          = "Height";
const QString MFieldReleaseDate     = "ReleaseDate";
const QString MFieldCopyright       = "Copyright";
const QString MFieldPath            = "Path";
const QString MFieldMime            = "Mime";
const QString MFieldComments        = "Comments";
const QString MFieldComment         = "Comment";

// Output names

const QString MPrefixAudio_out          = "audio:";
const QString MPrefixVideo_out          = "video:";
const QString MPrefixImage_out          = "image:";
const QString MPrefixFile_out           = "file:";

const QString MFieldTitle_out           = "title";
const QString MFieldArtist_out          = "artist";
const QString MFieldAlbum_out           = "album";
const QString MFieldGenre_out           = "genre";
const QString MFieldTrack_out           = "track";
const QString MFieldComposer_out        = "composer";
const QString MFieldDuration_out        = "duration";

const QString MFieldCameraMake_out      = "make";
const QString MFieldCameraModel_out     = "model";
const QString MFieldISOSpeed_out        = "iso";
const QString MFieldFNumber_out         = "fStop";
const QString MFieldFocalLenght_out     = "focalLength";
const QString MFieldOrientation_out     = "orientation";
const QString MFieldMeteringMode_out    = "meteringModel";
const QString MFieldFlash_out           = "flash";
const QString MFieldWhiteBalance_out    = "whiteBalance";
const QString MFieldExposureTime_out    = "exposure";
const QString MFieldOriginalDate_out    = "originalDate";

const QString MFieldSize_out            = "size";
const QString MFieldDate_out            = "date";
const QString MFieldName_out            = "name";
const QString MFieldWidth_out           = "width";
const QString MFieldHeight_out          = "height";
const QString MFieldReleaseDate_out     = "releaseDate";
const QString MFieldCopyright_out       = "copyright";
const QString MFieldPath_out            = "path";
const QString MFieldMime_out            = "mime";
const QString MFieldComments_out        = "comments";
const QString MFieldComment_out         = "comment";



typedef enum {
    CONTENT_FILES,
    CONTENT_IMAGES,
    CONTENT_MUSIC,
    CONTENT_VIDEOS,
    FIELD_URI
}ContentType;

typedef enum {
    AUDIO_FIELD_URI=0,
    AUDIO_FIELD_TYPE=1,
    AUDIO_FIELD_SIZE=2,
    AUDIO_FIELD_DATE=3,
    AUDIO_FIELD_TITLE=9,
    AUDIO_FIELD_GENRE=10,
    AUDIO_FIELD_TRACK=11,
    AUDIO_FIELD_ALBUM=12,
    AUDIO_FIELD_ARTIST=13,
    AUDIO_FIELD_DURATION=11,
    AUDIO_FIELD_COPYRIGHT=7,
    AUDIO_FIELD_COMMENT=6,
    AUDIO_FIELD_RELEASEDATE=8
}AudioFieldType;

typedef enum {
    VIDEO_FIELD_WIDTH=8,
    VIDEO_FIELD_HEIGHT=9,
    VIDEO_FIELD_DURATION=11,
    VIDEO_FIELD_COMMENTS=7,
    VIDEO_FIELD_SIZE=2,
    VIDEO_FIELD_TYPE=4,
    VIDEO_FIELD_COPYRIGHT=6,
    VIDEO_FIELD_URI=0,
    VIDEO_FIELD_TITLE=10,
    VIDEO_FIELD_DATE=3
}VideoFieldType;

typedef enum {
    IMAGE_FIELD_URI=0,
    IMAGE_FIELD_SIZE=2,
    IMAGE_FIELD_COPYRIGHT=6,
    IMAGE_FIELD_WIDTH=8,
    IMAGE_FIELD_HEIGHT=9,
    IMAGE_FIELD_TITLE=10,
    IMAGE_FIELD_CAMERAMAKE,
    IMAGE_FIELD_CAMERAMODEL,
    IMAGE_FIELD_ISOSPEED=13,
    IMAGE_FIELD_FNUMBER,
    IMAGE_FIELD_FOCALLENGHT,
    IMAGE_FIELD_ORIENTATION=16,
    IMAGE_FIELD_METERINGMODE,
    IMAGE_FIELD_FLASH=18,
    IMAGE_FIELD_WHITEBALANCE,
    IMAGE_FIELD_EXPOSURETIME,
    IMAGE_FIELD_COMMENTS,
    IMAGE_FIELD_ORIGINALDATE=21,
    IMAGE_FIELD_TYPE=1,
    IMAGE_FIELD_DATE=3
}ImageFieldType;

// RDFselect class object is used for creating of query to tracker
class RDFselect
{
//      Q_OBJECT
public:
    RDFselect();
    RDFselect(uint type):content_type(type){}

    //makeSelect() generates and run query by DBus interface to tracker and fills result list
    //before  of makeSelect() need to make invoke all functions which fill data for query
    bool makeSelect();

    //addColumn() - collects fields which will be used as data for query and needed for filling result list
    void addColumn(QString fieldname){ List_fields.append(fieldname); }

    //setQueryPropertyName() - set name of property used in query
    void setQueryPropertyName(QString fieldname) {property_name = fieldname;}

    // setQueryPropertyValue() set value of property used in query
    void setQueryPropertyValue(QString value) 
    {
        if( property_name.isEmpty() == false){  property_value = value; }
    }

    //setQuerySortBy() - set name of property for sorting used in query
    void setQuerySortBy(QString value) {orderby = value;}

    // setContentType() set type of content used in query
    void setContentType(uint type){content_type = type;}

    // setSortMethod() set method of sorting: DESCENDING or ASCENDING  used in query
    void setSortMethod(bool method){sortMethod = method;}

    // setTimeInterval() set start data and end data for query, if query use data instead of pair property=value
    void setTimeInterval(QDateTime start,QDateTime end){startDate = start; endDate = end;}

    // checkFileIndexed() - checks wether file exists in tracker DB
    bool checkFileIndexed(QString filePath);

    // result() - return filled result
    // before result() need to make invoke makeSelect()
    const QVariantList result(){return query_result;}



private:
// Name of tag in traker format used for query creating  
    QString property_name;
    // Value of tag  used for query creating 
    QString property_value;
    //Name of tag in traker format which value in result list will be sorted to alphabet
    QString orderby;
    // List of tags which need to fill in result list
    QStringList List_fields;
    // type of files(Music,Video,Images,Stream) used for query creating
    uint content_type;

    QString getServiceTypeAsString();

    QStringList getFieldsQArray();
    QStringList getOrderByQArray();

    bool sortMethod;

    QDateTime startDate;
    QDateTime endDate;

    QVariantMap  resultListItem(QStringList);

    QVariantList query_result;
};

#endif // RDFSELECT_H
