/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef MSSELECT_H
#define MSSELECT_H

#include <QVariantList>
#include <QStringList>

// MSselect class object is used for add, delete, select operaion in internet radio DB
class MSselect
{
public:
    MSselect();
    ~MSselect();
    //makeSelect() -select all radio streams from DB
    void makeSelect();
    //addStream() - add one stream to DB specified by uri
    void addStream(char * uri);
    void addStream(QString Quri){addStream(Quri.toLocal8Bit().constData());}
    //deleteStream() - delete one stream from DB specified by uri
    void deleteStream(char * uri);
    void deleteStream(QString Quri){deleteStream(Quri.toLocal8Bit().constData());}
    //checkExistsStream() - check  wether stream specified by uri exists in DB
    bool checkExistsStream(char * uri);
    bool checkExistsStream(QString Quri){return checkExistsStream(Quri.toLocal8Bit().constData());}
    // saveItem() - used for saving each of found stream in member list
    void saveItem(const char * uri);
    //saveObjId() - used for saving id of found stream
    void saveObjId(const char * id);
    int listCount(){return list.count();}
    const QVariantList result(){return list;}
    void resetList(){list.clear();}
private:
    QVariantList list;
    QStringList objId_list;
};

#endif // MSSELECT_H
