/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#include <QtGlobal>
#include <QDebug>

#include <glib.h>
#include <libmafw/mafw.h>
#include <libmafw/mafw-log.h>
#include <libmafw/mafw-registry.h>
#include <libmafw-shared/mafw-shared.h>

#include "msselect.h"


#define MAFW_IRADIO_EXTENTION_UUID "iradiosource"
#define MAFW_IRADIO_SOURCE_UUID "iradiosource::"
#define MAFW_IRADIO_PLUGIN_NAME "mafw-iradio-source"

const QString KUri = "uri";
const QString KSize = "size";
const QString KType = "type";
const QString KMediaTypeStream = "stream";

static GMainLoop * main_loop = NULL;

static void obi_created(MafwSource *self, const gchar *object_id,
                        gpointer user_data, const GError *error);

static void obi_destroyed(MafwSource *self, const gchar *object_id,
			  gpointer user_data, const GError *error);

static void browse_one_uri_cb(MafwSource *source, guint browse_id,
                              gint remaining_count, guint index, const gchar *object_id,
                              GHashTable *metadata, gpointer user_data, const GError *error);
/*
static void count_stations_cb(MafwSource *source, guint browse_id,
                              gint remaining_count, guint index, const gchar *object_id,
                              GHashTable *metadata, gpointer user_data, const GError *error);
*/


static void obi_created(MafwSource *self, const gchar *object_id,
                        gpointer user_data, const GError *error)
{
    qDebug("\n [obi_created]");
    if(object_id != NULL)
    {
        g_print ("[obi_created]object_id=%s \n",object_id);
    }
    else
    {
        g_print ("[obi_created] error:   object_id = NULL\n");
    }
    g_main_loop_quit (main_loop);
}

static void obi_destroyed(MafwSource *self, const gchar *object_id,
                          gpointer user_data, const GError *error)
{
    qDebug()<<"\n obi_destroyed object_id="<<object_id;
    g_main_loop_quit (main_loop);
}

static void browse_one_uri_cb(MafwSource *source, guint browse_id,
                              gint remaining_count, guint index, const gchar *object_id,
                              GHashTable *metadata, gpointer user_data, const GError *error)
{
    qDebug("\n[browse_one_uri_cb] ");
    qDebug()<<"remaining_count="<< remaining_count<<" index="<<index<<" object_id="<<object_id;

    if( object_id != NULL )
    {
        MSselect * select = (MSselect *)user_data;
        select->saveObjId((const char*)object_id);
    }

    if(remaining_count==0){g_main_loop_quit (main_loop);}
}

/*
static void count_stations_cb(MafwSource *source, guint browse_id,
                              gint remaining_count, guint index, const gchar *object_id,
                              GHashTable *metadata, gpointer user_data, const GError *error)
{

    if (metadata)
    {
        const gchar * buf=NULL;

        buf = g_value_get_string(mafw_metadata_first(metadata, MAFW_METADATA_KEY_MIME));
        buf = g_value_get_string(mafw_metadata_first(metadata, MAFW_METADATA_KEY_URI));
        if( buf != NULL )
        {

            if(user_data!=NULL)
            {
                MSselect * select=(MSselect *)user_data;
                select->saveItem((const char*)buf);
            }
            else
            {
                qDebug("[count_stations_cb] user_data=NULL");
            }

        }

    }
    if(remaining_count==0){g_main_loop_quit (main_loop);}
}
*/


MSselect::MSselect()
{
    GError *error=NULL;
    gboolean retv=false;

    qDebug("[MSselect] load plugin");
    MafwRegistry *registry = MAFW_REGISTRY(mafw_registry_get_instance());
    if(!registry )
    {
        qDebug("error: registry = NULL");

    }
    retv= mafw_registry_load_plugin(registry,MAFW_IRADIO_PLUGIN_NAME, &error);
    if(retv && !error)
    {
        qDebug("[MSselect]  plugin loaded");
    }
    else
    {
        qDebug("[MSselect]error: plugin not loaded");
    }

    main_loop = g_main_loop_new (NULL, FALSE);
    objId_list.clear();
}


MSselect::~MSselect()
{
    GError *error=NULL;
    gboolean retv=false;

    qDebug("[~MSselect] unload plugin");
    retv = mafw_registry_unload_plugin(MAFW_REGISTRY(mafw_registry_get_instance()),
                                       MAFW_IRADIO_PLUGIN_NAME, &error);
    if(retv && !error)
    {
        qDebug ("[~MSselect]  plugin unloaded");
    }
    else
    {
        qDebug ("[~MSselect]error: plugin not unloaded");
    }

    objId_list.clear();
}


void MSselect::makeSelect()
{
    qDebug("[browse]");
    MafwRegistry *registry = MAFW_REGISTRY(mafw_registry_get_instance());
    if(!registry)
    {
        qDebug()<< Q_FUNC_INFO;
        return;
    }
    MafwExtension *iradio_source = mafw_registry_get_extension_by_uuid( registry,
                                                                        MAFW_IRADIO_EXTENTION_UUID);

    if(!iradio_source )
    {
        qDebug()<<"[browse]error: iradio_source = NULL"<< Q_FUNC_INFO;
        return;
    }
    qDebug ("[browse] browse...\n");
    g_main_loop_run (main_loop);

}

void MSselect::addStream(char * uri)
{
    qDebug("[addStream] uri=%s",uri);
    MafwRegistry *registry = MAFW_REGISTRY(mafw_registry_get_instance());
    if(!registry)
    {
        qDebug()<< Q_FUNC_INFO;
        return;
    }
    MafwExtension *iradio_source = mafw_registry_get_extension_by_uuid( registry,
                                                                        MAFW_IRADIO_EXTENTION_UUID);

    if(!iradio_source )
    {
        qDebug() << "[addStream]error: iradio_source = NULL" << Q_FUNC_INFO;
        return;
    }

    GHashTable *mdat;

    mdat = mafw_metadata_new();
    mafw_metadata_add_str(mdat, MAFW_METADATA_KEY_MIME,"audio/unknown");
    mafw_metadata_add_str(mdat, MAFW_METADATA_KEY_URI, uri );
    mafw_metadata_add_str(mdat, MAFW_METADATA_KEY_TITLE,"added test iradio");

    qDebug ("[INFO]  create_object.");
    mafw_source_create_object(MAFW_SOURCE(iradio_source),MAFW_IRADIO_SOURCE_UUID, mdat, obi_created, NULL);

    mafw_metadata_release(mdat);
    g_main_loop_run (main_loop);
}


void MSselect::deleteStream(char * uri)
{
    qDebug("[deleteStream] uri=%s",uri);
    MafwRegistry *registry = MAFW_REGISTRY(mafw_registry_get_instance());
    if(!registry)
    {
        qDebug()<< Q_FUNC_INFO;
        return;
    }
    MafwExtension *iradio_source = mafw_registry_get_extension_by_uuid( registry,
                                                                        MAFW_IRADIO_EXTENTION_UUID);

    if(!iradio_source )
    {
        qDebug() << "[deleteStream]error: iradio_source = NULL" << Q_FUNC_INFO;
        return;
    }
/*
    MafwFilter *filter = NULL;
    char * filterstr=g_strdup_printf("(%s=%s)",MAFW_METADATA_KEY_URI,uri);
    filter = mafw_filter_parse(filterstr);
*/
    objId_list.clear();
    g_main_loop_run (main_loop);

    qDebug ("[deleteStream] count for delete=%d\n",objId_list.count());
    for(int i=0; i<objId_list.count(); i++)
    {
        qDebug ()<<"[deleteStream] obj_id="<< objId_list.at(i) ;
        mafw_source_destroy_object(MAFW_SOURCE(iradio_source),
                                   objId_list.at(i).toLocal8Bit().constData() , obi_destroyed, NULL);
        g_main_loop_run (main_loop);
    }

}

bool MSselect::checkExistsStream(char * uri)
{
    qDebug("[checkExistsStream] uri=%s",uri);
    MafwRegistry *registry = MAFW_REGISTRY(mafw_registry_get_instance());
    if(!registry)
    {
        qDebug()<< Q_FUNC_INFO;
        return FALSE;
    }
    MafwExtension *iradio_source = mafw_registry_get_extension_by_uuid( registry,
                                                                        MAFW_IRADIO_EXTENTION_UUID);

    if(!iradio_source )
    {
        qDebug() << "[checkExistsStream]error: iradio_source = NULL" << Q_FUNC_INFO;
        return FALSE;
    }
/*
    MafwFilter *filter = NULL;
    char * filterstr=g_strdup_printf("(%s=%s)",MAFW_METADATA_KEY_URI,uri);
    filter = mafw_filter_parse(filterstr);
*/
    qDebug ("[checkExistsStream] browse...\n");
    objId_list.clear();
    g_main_loop_run (main_loop);
    qDebug ("[checkExistsStream] return =%d\n",!objId_list.isEmpty());
    return !objId_list.isEmpty();
}

void MSselect::saveItem(const char * uri)
{

    QVariantMap item;
    item.insert(KUri, QString(uri));
    item.insert(KSize, "0");
    item.insert(KType, KMediaTypeStream);

    list.append(static_cast<QVariant>(item));
}

void MSselect::saveObjId(const char * id)
{
    qDebug()<<"[saveObjId] id="<<id;
    objId_list<<id;
}
