/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#include <QDebug>

#include "mediafilter.h"
#include "qmediaerrorcodes.h"
#include "qmediakeyconstants.h"

bool MediaFilter::fillFilterData(const QVariantMap& aMatch,
                                 const int aSortOrder, int& aErrorCode, QString& aErrorMessage)
{
    iSortMethod = aSortOrder;
    qDebug(__PRETTY_FUNCTION__);
    bool validPattern = false;

    if(aMatch.contains(KType))
    {
        if(validateMediaType(aMatch[KType], aErrorCode, aErrorMessage))
        {
            if(aMatch.contains(KField))
            {
                QVariant field = aMatch[KField];
                qDebug() << "field.type() = " << field.type();
                if(field.type() == QVariant::Map)
                {
                    validPattern = validateFilterField(field, aErrorCode, aErrorMessage);
                }
                else
                {
                    aErrorCode = INVALID_ARG_ERR;
                    aErrorMessage = "getList: Invalid field in match pattern";
                }
            }
            else if(aMatch.contains(KDateRange))
            {
                QVariant field = aMatch[KDateRange];
                if(field.type() == QVariant::Map)
                {
                    validPattern = validateDateRangeField(field, aErrorCode, aErrorMessage);
                }
                else
                {
                    aErrorCode = INVALID_ARG_ERR;
                    aErrorMessage = "getList: Invalid dateRange in match pattern";
                    validPattern = false;
                }
            }
            else
            {
                validPattern  = true;
            }
            if(validPattern && aMatch.contains(KSortBy))
            {
                QVariant field = aMatch[KSortBy];

                if(field.type() == QVariant::String)
                {
                    validPattern = validateSortbyField(field, aErrorCode, aErrorMessage);
                }
                else
                {
                    aErrorCode = INVALID_ARG_ERR;
                    aErrorMessage = "getList: Invalid sortBy in match pattern";
                    validPattern = false;
                }
            }
        }
        else
        {
            validPattern = false;
        }
    }
    else
    {
        aErrorCode = MISSING_ARG_ERR;
        aErrorMessage = "getList: Missing type in match pattern";
        validPattern = false;
    }
    return validPattern;
}

bool MediaFilter::validateFilterField( const QVariant& aFilterField,
                                       int& aErrorCode,
                                       QString& aErrorMessage)
{
    qDebug() << __PRETTY_FUNCTION__;
    bool validFilterField = false;
    QVariantMap qtFieldMap = aFilterField.toMap();

    if(qtFieldMap.contains(KFieldName) && qtFieldMap.contains(KFieldValue))
    {
        QVariant fieldVName = qtFieldMap[KFieldName];
        QVariant fieldVValue = qtFieldMap[KFieldValue];

        if((fieldVName.type() == QVariant::String) && (fieldVValue.type() == QVariant::String))
        {
            int64 fieldName = getHashValue( fieldVName.toString().toLower());
            QString fieldValue = fieldVValue.toString();

            switch(iMediaType)
            {
            case KMFIMAGE:
                if((KMFIMAGEIPMASK & fieldName) > 0 )
                {
                    iFilterFlags = fieldName;
                    validFilterField = true;
                }
                break;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             case KMFAUDIO:
                if((KMFAUDIOIPMASK & fieldName) > 0 )
                {
                    iFilterFlags = fieldName;
                    validFilterField = true;
                }
                break;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             case KMFVIDEO:
                if((KMFTRACK & fieldName) > 0)
                {
                    validFilterField = false;
                    break;
                }
                if((KMFVIDEOIPMASK & fieldName) > 0)
                {
                    iFilterFlags = fieldName;
                    validFilterField = true;
                }
                break;
            }

            if( validFilterField )
            {
                qDebug() << "Filter field valid. Value = [" << qPrintable(fieldValue) << "]";
                iFilterValue = fieldValue;
            }
            else
            {
                if(((iMediaType & KMFVIDEO ) > 0) && ((KMFTRACK & fieldName) > 0) )
                {
                    aErrorCode = NOT_SUPPORTED_ERR;
                    aErrorMessage = "getList: track is not supproted field for video";
                }
                else
                {
                    aErrorCode = INVALID_ARG_ERR;
                    aErrorMessage = "getList: Invalid field in pattern";
                }
            }
        }
        else
        {
            aErrorCode = INVALID_ARG_ERR;
            if(fieldVName.type() != QVariant::String)
                aErrorMessage = "getList: Invalid field.name type";
            else
                aErrorMessage = "getList: Invalid field.value type";

        }
    }
    else
    {
        aErrorCode = INVALID_ARG_ERR;
        if(!qtFieldMap.contains(KFieldName))
            aErrorMessage = "getList:  field.name is not defined";
        else
            aErrorMessage = "getList: field.value is not defined";
    }

    qDebug() << "MediaFilter::validateFilterField end. ret=" << validFilterField << "errCode=" << aErrorCode << " ErrMsg" << aErrorMessage;
    return validFilterField;
}

bool MediaFilter::validateSortbyField(const QVariant& aSortBy,
                                      int& aErrorCode,
                                      QString& aErrorMessage)
{
    qDebug(__PRETTY_FUNCTION__);
    bool validateSortField = false;
    QString qtSortBy = aSortBy.toString().toLower();

    int64 sortField = getHashValue(qtSortBy);

    switch(iMediaType)
    {
    case KMFIMAGE :
        if((KMFIMAGESORTMASK & sortField) >0 )
        {
            validateSortField = true;
            iSortFlags = sortField;
        }
        break;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                case KMFAUDIO:
        if((KMFAUDIOSORTMASK & sortField) > 0)
        {
            validateSortField = true;
            iSortFlags = sortField;
        }
        break;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                case KMFVIDEO:
        if((KMFTRACK & sortField) > 0)
        {
            validateSortField = false;
            break;
        }
        if((KMFVIDEOSORTMASK & sortField) > 0)
        {
            validateSortField = true;
            iSortFlags = sortField;
        }
        break;
    }

    if(!validateSortField)
    {
        if(((iMediaType & KMFVIDEO ) > 0) && ((KMFTRACK & sortField) > 0))
        {
            aErrorCode = NOT_SUPPORTED_ERR;
            aErrorMessage = "getList: track is not supported field for video";
        }
        else
        {
            aErrorCode = INVALID_ARG_ERR;
            aErrorMessage = "getList: Invalid sortBy in pattern";
        }
    }
    qDebug() << "MediaFilter::validateSortbyField end. ret=" << validateSortField << " errCode=" << aErrorCode << " ErrMsg=" << aErrorMessage;
    return validateSortField;
}

bool MediaFilter::validateDateRangeField( const QVariant& aDateRange,
                                          int& aErrorCode,
                                          QString& aErrorMessage)
{
    qDebug(__PRETTY_FUNCTION__);
    bool dateRangeValid = true;
    QVariantMap qtDateRangeMap = aDateRange.toMap();

    if(qtDateRangeMap.contains(KDateStart))
    {
        QVariant startDate = qtDateRangeMap[KDateStart];
        if(startDate.type() == QVariant::DateTime)
        {
            QDateTime stDateTime = startDate.toDateTime();
            iStartTime = stDateTime;
        }
        else
        {
            aErrorCode = INVALID_ARG_ERR;
            aErrorMessage = "getList: Invalid start date";
            dateRangeValid = false;
        }
    }

    if(dateRangeValid && qtDateRangeMap.contains(KDateEnd))
    {
        QVariant endDate = qtDateRangeMap[KDateEnd];
        if(endDate.type() == QVariant::DateTime)
        {
            QDateTime endDateTime = endDate.toDateTime();
            iEndTime = endDateTime;

            if(iEndTime < iStartTime)
            {
                aErrorCode = INVALID_ARG_ERR;
                aErrorMessage = "getList: EndDate less than StartDate";
                dateRangeValid = false;
            }
        }
        else
        {
            aErrorCode = INVALID_ARG_ERR;
            aErrorMessage = "getList: Invalid end date";
            dateRangeValid = false;
        }
    }
    qDebug() << "MediaFilter::validateDateRangeField. Start=" << iStartTime << " End=" << iEndTime;
    qDebug() << "MediaFilter::validateDateRangeField end. ret=" << dateRangeValid << " errCode=" << aErrorCode << " ErrMsg=";
    return dateRangeValid;
}

bool MediaFilter::validateMediaType(const QVariant& aMediaType,
                                    int& aErrorCode,
                                    QString& aErrorMessage)
{
    qDebug(__PRETTY_FUNCTION__);
    bool typeValid = false;
    if( aMediaType.type() == QVariant::String)
    {

        int64 mediaType = getHashValue(aMediaType.toString().toLower().trimmed());

        qDebug() << "Media type: " << qPrintable(aMediaType.toString());
        switch( mediaType )
        {
        case KMFIMAGE:
        case KMFAUDIO:
        case KMFVIDEO:
        case KMFSTREAM:
        case KMFALL:
            typeValid = true;
            iMediaType = mediaType;
            break;

        default:
            aErrorCode = INVALID_ARG_ERR;
            aErrorMessage = "getList: Invalid media type";
            break;
        }
    }
    else
    {
        aErrorCode = INVALID_ARG_ERR;
        aErrorMessage = "getList: Invalid media type";
    }
    qDebug() << "MediaFilter::validateMediaType end. ret=" << typeValid << " errCode=" << aErrorCode << " ErrMsg=" << aErrorMessage << ". Media type=" << iMediaType;
    return typeValid;
}

int64 MediaFilter::getHashValue(const QString& aStringValue)
{
    for(int i=0; i<mediaFieldList.length(); i++)
    {
        if (mediaFieldList[i] == aStringValue)
        {
            return KBASE<<i;
        }
    }
    return 0;
}
